/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.sdk;

import com.intellij.ide.browsers.chrome.ChromeSettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BooleanFunction;
import com.intellij.util.SmartList;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.ide.runner.client.DartiumUtil;
import com.jetbrains.lang.dart.sdk.DartSdk;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartSdkUtil {
    private static final Map<Pair<File, Long>, String> ourVersions = new HashMap<Pair<File, Long>, String>();
    private static final String DART_SDK_KNOWN_PATHS = "DART_SDK_KNOWN_PATHS";
    private static final String DARTIUM_KNOWN_PATHS = "DARTIUM_KNOWN_PATHS";

    @Nullable
    public static String getSdkVersion(@NotNull String sdkHomePath) {
        String cachedVersion;
        if (sdkHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHomePath", "com/jetbrains/lang/dart/sdk/DartSdkUtil", "getSdkVersion"));
        }
        File versionFile = new File(sdkHomePath + "/version");
        if (versionFile.isFile() && (cachedVersion = ourVersions.get(Pair.create((Object)versionFile, (Object)versionFile.lastModified()))) != null) {
            return cachedVersion;
        }
        String version = DartSdkUtil.readVersionFile(sdkHomePath);
        if (version != null) {
            ourVersions.put((Pair<File, Long>)Pair.create((Object)versionFile, (Object)versionFile.lastModified()), version);
            return version;
        }
        return null;
    }

    private static String readVersionFile(String sdkHomePath) {
        File versionFile = new File(sdkHomePath + "/version");
        if (versionFile.isFile() && versionFile.length() < 100L) {
            try {
                return FileUtil.loadFile((File)versionFile).trim();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Contract(value="null->false")
    public static boolean isDartSdkHome(@Nullable String path) {
        return path != null && !path.isEmpty() && new File(path + "/lib/core/core.dart").isFile();
    }

    public static void initDartSdkAndDartiumControls(@Nullable Project project, final @NotNull ComboboxWithBrowseButton dartSdkPathComponent, final @NotNull JBLabel versionLabel, final @NotNull ComboboxWithBrowseButton dartiumPathComponent, final @NotNull Computable<ChromeSettings> currentDartiumSettingsRetriever, final @NotNull JButton dartiumSettingsButton, final @NotNull Computable<Boolean> isResettingControlsComputable) {
        if (dartSdkPathComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartSdkPathComponent", "com/jetbrains/lang/dart/sdk/DartSdkUtil", "initDartSdkAndDartiumControls"));
        }
        if (versionLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionLabel", "com/jetbrains/lang/dart/sdk/DartSdkUtil", "initDartSdkAndDartiumControls"));
        }
        if (dartiumPathComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartiumPathComponent", "com/jetbrains/lang/dart/sdk/DartSdkUtil", "initDartSdkAndDartiumControls"));
        }
        if (currentDartiumSettingsRetriever == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentDartiumSettingsRetriever", "com/jetbrains/lang/dart/sdk/DartSdkUtil", "initDartSdkAndDartiumControls"));
        }
        if (dartiumSettingsButton == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartiumSettingsButton", "com/jetbrains/lang/dart/sdk/DartSdkUtil", "initDartSdkAndDartiumControls"));
        }
        if (isResettingControlsComputable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isResettingControlsComputable", "com/jetbrains/lang/dart/sdk/DartSdkUtil", "initDartSdkAndDartiumControls"));
        }
        dartSdkPathComponent.getComboBox().setEditable(true);
        DartSdkUtil.addKnownPathsToCombo(dartSdkPathComponent.getComboBox(), DART_SDK_KNOWN_PATHS, (BooleanFunction<String>)((BooleanFunction)path -> DartSdkUtil.isDartSdkHome(path)));
        dartiumPathComponent.getComboBox().setEditable(true);
        DartSdkUtil.addKnownPathsToCombo(dartiumPathComponent.getComboBox(), DARTIUM_KNOWN_PATHS, (BooleanFunction<String>)((BooleanFunction)path -> !path.isEmpty() && new File((String)path).exists()));
        String sdkHomePath = dartSdkPathComponent.getComboBox().getEditor().getItem().toString().trim();
        versionLabel.setText(sdkHomePath.isEmpty() ? "" : DartSdkUtil.getSdkVersion(sdkHomePath));
        TextComponentAccessor<JComboBox> textComponentAccessor = new TextComponentAccessor<JComboBox>(){

            public String getText(JComboBox component) {
                return component.getEditor().getItem().toString();
            }

            public void setText(@NotNull JComboBox component, @NotNull String text) {
                String probablySdkPath;
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/lang/dart/sdk/DartSdkUtil$1", "setText"));
                }
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/lang/dart/sdk/DartSdkUtil$1", "setText"));
                }
                if (!text.isEmpty() && !DartSdkUtil.isDartSdkHome(text) && DartSdkUtil.isDartSdkHome(probablySdkPath = text + "/dart-sdk")) {
                    component.getEditor().setItem(FileUtilRt.toSystemDependentName((String)probablySdkPath));
                    return;
                }
                component.getEditor().setItem(FileUtilRt.toSystemDependentName((String)text));
            }
        };
        ComponentWithBrowseButton.BrowseFolderActionListener browseFolderListener = new ComponentWithBrowseButton.BrowseFolderActionListener("Select Dart SDK path", null, (ComponentWithBrowseButton)dartSdkPathComponent, project, FileChooserDescriptorFactory.createSingleFolderDescriptor(), (TextComponentAccessor)textComponentAccessor);
        dartSdkPathComponent.addActionListener((ActionListener)browseFolderListener);
        dartiumPathComponent.addBrowseFolderListener("Select Dartium browser path", null, project, FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor(), TextComponentAccessor.STRING_COMBOBOX_WHOLE_TEXT);
        JTextComponent editorComponent = (JTextComponent)dartSdkPathComponent.getComboBox().getEditor().getEditorComponent();
        editorComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                String dartiumPath;
                String sdkHomePath = dartSdkPathComponent.getComboBox().getEditor().getItem().toString().trim();
                versionLabel.setText(sdkHomePath.isEmpty() ? "" : DartSdkUtil.getSdkVersion(sdkHomePath));
                if (!((Boolean)isResettingControlsComputable.compute()).booleanValue() && DartSdkUtil.isDartSdkHome(sdkHomePath) && (dartiumPath = DartiumUtil.getDartiumPathForSdk(sdkHomePath)) != null) {
                    dartiumPathComponent.getComboBox().getEditor().setItem(FileUtilRt.toSystemDependentName((String)dartiumPath));
                }
            }
        });
        dartiumSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowSettingsUtil.getInstance().editConfigurable((Component)dartiumSettingsButton, (Configurable)((ChromeSettings)currentDartiumSettingsRetriever.compute()).createConfigurable());
            }
        });
    }

    @Nullable
    public static String getFirstKnownDartSdkPath() {
        String[] knownPaths = PropertiesComponent.getInstance().getValues(DART_SDK_KNOWN_PATHS);
        if (knownPaths != null && knownPaths.length > 0 && DartSdkUtil.isDartSdkHome(knownPaths[0])) {
            return knownPaths[0];
        }
        return null;
    }

    private static void addKnownPathsToCombo(@NotNull JComboBox combo, @NotNull String propertyKey, @NotNull BooleanFunction<String> pathChecker) {
        String[] knownPaths;
        if (combo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "combo", "com/jetbrains/lang/dart/sdk/DartSdkUtil", "addKnownPathsToCombo"));
        }
        if (propertyKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyKey", "com/jetbrains/lang/dart/sdk/DartSdkUtil", "addKnownPathsToCombo"));
        }
        if (pathChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathChecker", "com/jetbrains/lang/dart/sdk/DartSdkUtil", "addKnownPathsToCombo"));
        }
        SmartList validPathsForUI = new SmartList();
        String currentPath = combo.getEditor().getItem().toString().trim();
        if (!currentPath.isEmpty()) {
            validPathsForUI.add((Object)currentPath);
        }
        if ((knownPaths = PropertiesComponent.getInstance().getValues(propertyKey)) != null && knownPaths.length > 0) {
            for (String path : knownPaths) {
                String pathSD = FileUtil.toSystemDependentName((String)path);
                if (pathSD.equals(currentPath) || !pathChecker.fun((Object)path)) continue;
                validPathsForUI.add((Object)pathSD);
            }
        }
        combo.setModel(new DefaultComboBoxModel<String>(ArrayUtil.toStringArray((Collection)validPathsForUI)));
    }

    public static void updateKnownSdkPaths(@NotNull Project project, @NotNull String newSdkPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/sdk/DartSdkUtil", "updateKnownSdkPaths"));
        }
        if (newSdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSdkPath", "com/jetbrains/lang/dart/sdk/DartSdkUtil", "updateKnownSdkPaths"));
        }
        DartSdk oldSdk = DartSdk.getDartSdk(project);
        DartSdkUtil.updateKnownPaths(DART_SDK_KNOWN_PATHS, oldSdk == null ? null : oldSdk.getHomePath(), newSdkPath);
    }

    public static void updateKnownDartiumPaths(@Nullable String oldPath, @NotNull String newPath) {
        if (newPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newPath", "com/jetbrains/lang/dart/sdk/DartSdkUtil", "updateKnownDartiumPaths"));
        }
        DartSdkUtil.updateKnownPaths(DARTIUM_KNOWN_PATHS, oldPath, newPath);
    }

    private static void updateKnownPaths(@NotNull String propertyKey, @Nullable String oldPath, @NotNull String newPath) {
        if (propertyKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyKey", "com/jetbrains/lang/dart/sdk/DartSdkUtil", "updateKnownPaths"));
        }
        if (newPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newPath", "com/jetbrains/lang/dart/sdk/DartSdkUtil", "updateKnownPaths"));
        }
        ArrayList<String> knownPaths = new ArrayList<String>();
        String[] oldKnownPaths = PropertiesComponent.getInstance().getValues(propertyKey);
        if (oldKnownPaths != null) {
            knownPaths.addAll(Arrays.asList(oldKnownPaths));
        }
        if (oldPath != null) {
            knownPaths.remove(oldPath);
            knownPaths.add(0, oldPath);
        }
        knownPaths.remove(newPath);
        knownPaths.add(0, newPath);
        if (knownPaths.isEmpty()) {
            PropertiesComponent.getInstance().unsetValue(propertyKey);
        } else {
            PropertiesComponent.getInstance().setValues(propertyKey, ArrayUtil.toStringArray(knownPaths));
        }
    }

    @Nullable
    public static String getErrorMessageIfWrongSdkRootPath(@NotNull String sdkRootPath) {
        if (sdkRootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkRootPath", "com/jetbrains/lang/dart/sdk/DartSdkUtil", "getErrorMessageIfWrongSdkRootPath"));
        }
        if (sdkRootPath.isEmpty()) {
            return DartBundle.message("error.path.to.sdk.not.specified", new Object[0]);
        }
        File sdkRoot = new File(sdkRootPath);
        if (!sdkRoot.isDirectory()) {
            return DartBundle.message("error.folder.specified.as.sdk.not.exists", new Object[0]);
        }
        if (!DartSdkUtil.isDartSdkHome(sdkRootPath)) {
            return DartBundle.message("error.sdk.not.found.in.specified.location", new Object[0]);
        }
        return null;
    }

    public static String getDartExePath(@NotNull DartSdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/lang/dart/sdk/DartSdkUtil", "getDartExePath"));
        }
        return sdk.getHomePath() + (SystemInfo.isWindows ? "/bin/dart.exe" : "/bin/dart");
    }

    public static String getPubPath(@NotNull DartSdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/lang/dart/sdk/DartSdkUtil", "getPubPath"));
        }
        return DartSdkUtil.getPubPath(sdk.getHomePath());
    }

    public static String getPubPath(@NotNull String sdkRoot) {
        if (sdkRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkRoot", "com/jetbrains/lang/dart/sdk/DartSdkUtil", "getPubPath"));
        }
        return sdkRoot + (SystemInfo.isWindows ? "/bin/pub.bat" : "/bin/pub");
    }

    public static String getPubSnapshotPath(@NotNull DartSdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/lang/dart/sdk/DartSdkUtil", "getPubSnapshotPath"));
        }
        return sdk.getHomePath() + "/bin/snapshots/pub.dart.snapshot";
    }
}

