/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.test;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.projectView.DartIconProvider;
import org.jetbrains.annotations.NotNull;

public class DartTestSourcesFilter
extends TestSourcesFilter {
    public boolean isTestSource(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/test/DartTestSourcesFilter", "isTestSource"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/test/DartTestSourcesFilter", "isTestSource"));
        }
        if (!file.isInLocalFileSystem()) {
            return false;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        if (!fileIndex.isInContent(file)) {
            return false;
        }
        if (DartIconProvider.isFolderNearPubspecYaml(file, "test")) {
            return true;
        }
        if (!file.getPath().contains("/test/")) {
            return false;
        }
        VirtualFile parent = file;
        while ((parent = parent.getParent()) != null && fileIndex.isInContent(parent)) {
            if (!DartIconProvider.isFolderNearPubspecYaml(parent, "test")) continue;
            return true;
        }
        return false;
    }
}

