/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartBuildFileUtil {
    public static final String BUILD_FILE_NAME = "BUILD";
    public static final String LIB_DIR_NAME = "lib";

    @Nullable
    public static VirtualFile findPackageRootBuildFile(@NotNull Project project, @NotNull VirtualFile contextFile) {
        VirtualFile parent;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/util/DartBuildFileUtil", "findPackageRootBuildFile"));
        }
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFile", "com/jetbrains/lang/dart/util/DartBuildFileUtil", "findPackageRootBuildFile"));
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile virtualFile = parent = contextFile.isDirectory() ? contextFile : contextFile.getParent();
        while (parent != null && fileIndex.isInContent(parent)) {
            VirtualFile parent2;
            VirtualFile file = parent.findChild(BUILD_FILE_NAME);
            if (file != null && !file.isDirectory() && (parent2 = parent.getParent()) != null && parent2.findChild(LIB_DIR_NAME) == null) {
                return file;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Nullable
    public static String getDartProjectName(@NotNull VirtualFile buildFile) {
        if (buildFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildFile", "com/jetbrains/lang/dart/util/DartBuildFileUtil", "getDartProjectName"));
        }
        return buildFile.getParent().getName();
    }
}

