/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.util;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartExecutionScope;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.DartType;
import com.jetbrains.lang.dart.util.DartClassResolveResult;
import com.jetbrains.lang.dart.util.DartControlFlowUtil;
import com.jetbrains.lang.dart.util.DartPresentableUtil;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import java.util.ArrayList;
import java.util.List;

public class DartControlFlow {
    private List<DartComponentName> myParameters;
    private final List<DartComponentName> myReturnValues;

    protected DartControlFlow(List<DartComponentName> inComponentNames, List<DartComponentName> outDeclarations) {
        this.myParameters = inComponentNames;
        this.myReturnValues = outDeclarations;
    }

    public List<DartComponentName> getParameters() {
        return this.myParameters;
    }

    public List<DartComponentName> getReturnValues() {
        return this.myReturnValues;
    }

    public static DartControlFlow analyze(PsiElement[] elements) {
        PsiElement scope = PsiTreeUtil.getTopmostParentOfType((PsiElement)elements[0], DartExecutionScope.class);
        PsiElement lastElement = elements[elements.length - 1];
        int lastElementEndOffset = lastElement.getTextRange().getEndOffset();
        int firstElementStartOffset = elements[0].getTextRange().getStartOffset();
        assert (scope != null);
        LocalSearchScope localSearchScope = new LocalSearchScope(scope);
        List outDeclarations = ContainerUtil.filter(DartControlFlowUtil.getSimpleDeclarations(elements, null, false), componentName -> {
            for (PsiReference usage : ReferencesSearch.search((PsiElement)componentName, (SearchScope)localSearchScope, (boolean)false).findAll()) {
                if (usage.getElement().getTextRange().getStartOffset() <= lastElementEndOffset) continue;
                return true;
            }
            return false;
        });
        DartReferenceVisitor dartReferenceVisitor = new DartReferenceVisitor();
        for (PsiElement element : elements) {
            element.accept((PsiElementVisitor)dartReferenceVisitor);
        }
        List inComponentNames = ContainerUtil.filter(dartReferenceVisitor.getComponentNames(), componentName -> {
            int offset = componentName.getTextRange().getStartOffset();
            boolean declarationInElements = firstElementStartOffset <= offset && offset < lastElementEndOffset;
            return !declarationInElements;
        });
        return new DartControlFlow(inComponentNames, outDeclarations);
    }

    public void filterParams(Condition<? super DartComponentName> condition) {
        this.myParameters = ContainerUtil.filter(this.myParameters, condition);
    }

    public String getReplaceStatementText(String functionName) {
        StringBuilder result = new StringBuilder();
        if (!this.myReturnValues.isEmpty()) {
            DartComponentName componentName = this.myReturnValues.iterator().next();
            result.append("var ");
            result.append(componentName.getName());
            result.append(" = ");
        }
        result.append(this.getSignature(functionName, false));
        return result.toString();
    }

    private void appendFirstReturnTypeName(StringBuilder result) {
        DartComponentName componentName = this.myReturnValues.iterator().next();
        DartClassResolveResult resolveResult = DartResolveUtil.getDartClassResolveResult((PsiElement)componentName);
        DartClass dartClass = resolveResult.getDartClass();
        if (dartClass != null) {
            result.append(DartPresentableUtil.buildClassText(dartClass, resolveResult.getSpecialization()));
            result.append(" ");
        }
    }

    public String getSignature(String functionName) {
        return this.getSignature(functionName, true);
    }

    private String getSignature(String functionName, boolean declaration) {
        StringBuilder result = new StringBuilder();
        if (declaration && !this.myReturnValues.isEmpty()) {
            this.appendFirstReturnTypeName(result);
        }
        result.append(functionName);
        result.append("(");
        for (int i = 0; i < this.myParameters.size(); ++i) {
            if (i > 0) {
                result.append(", ");
            }
            DartComponentName componentName = this.myParameters.get(i);
            DartClassResolveResult resolveResult = DartResolveUtil.getDartClassResolveResult((PsiElement)componentName);
            DartClass dartClass = resolveResult.getDartClass();
            if (declaration && dartClass != null) {
                String typeText = DartPresentableUtil.buildClassText(dartClass, resolveResult.getSpecialization());
                result.append(typeText).append(" ");
            }
            result.append(componentName.getName());
        }
        result.append(")");
        return result.toString();
    }

    private static class DartReferenceVisitor
    extends PsiRecursiveElementVisitor {
        private final List<DartComponentName> myComponentNames = new ArrayList<DartComponentName>();

        private DartReferenceVisitor() {
        }

        public List<DartComponentName> getComponentNames() {
            return this.myComponentNames;
        }

        public void visitElement(PsiElement element) {
            PsiElement resolve;
            if (element instanceof DartType) {
                return;
            }
            if (element instanceof DartReference && DartResolveUtil.aloneOrFirstInChain((DartReference)element) && (resolve = ((DartReference)element).resolve()) instanceof DartComponentName && !this.myComponentNames.contains((DartComponentName)resolve)) {
                this.myComponentNames.add((DartComponentName)resolve);
            }
            super.visitElement(element);
        }
    }
}

