/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.util;

import com.intellij.psi.PsiElement;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartVarAccessDeclaration;
import com.jetbrains.lang.dart.psi.DartVarDeclarationList;
import com.jetbrains.lang.dart.psi.DartVarDeclarationListPart;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class DartControlFlowUtil {
    public static Set<DartComponentName> getSimpleDeclarations(PsiElement[] children, @Nullable PsiElement lastParent, boolean stopAtLastParent) {
        THashSet result = new THashSet();
        boolean addComponentsFlag = true;
        for (PsiElement child : children) {
            boolean isFieldOrVar;
            if (child == lastParent && stopAtLastParent) {
                addComponentsFlag = false;
            }
            if (addComponentsFlag && child instanceof DartVarDeclarationList) {
                DartControlFlowUtil.addFromVarDeclarationList((Set<DartComponentName>)result, (DartVarDeclarationList)child);
                continue;
            }
            if (!(child instanceof DartComponent)) continue;
            boolean bl = isFieldOrVar = child instanceof DartVarAccessDeclaration || child instanceof DartVarDeclarationListPart;
            if (isFieldOrVar) continue;
            result.add(((DartComponent)child).getComponentName());
        }
        return result;
    }

    public static void addFromVarDeclarationList(Set<DartComponentName> result, DartVarDeclarationList declarationList) {
        result.add(declarationList.getVarAccessDeclaration().getComponentName());
        for (DartVarDeclarationListPart declarationListPart : declarationList.getVarDeclarationListPartList()) {
            result.add(declarationListPart.getComponentName());
        }
    }
}

