/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartTypeArguments;
import com.jetbrains.lang.dart.util.DartClassResolveResult;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartGenericSpecialization
implements Cloneable {
    public static final DartGenericSpecialization EMPTY = new DartGenericSpecialization();
    final Map<String, DartClassResolveResult> map;

    public DartGenericSpecialization() {
        this((Map<String, DartClassResolveResult>)new THashMap());
    }

    protected DartGenericSpecialization(Map<String, DartClassResolveResult> map) {
        this.map = map;
    }

    public DartGenericSpecialization clone() {
        THashMap clonedMap = new THashMap();
        for (String key : this.map.keySet()) {
            clonedMap.put(key, this.map.get(key));
        }
        return new DartGenericSpecialization((Map<String, DartClassResolveResult>)clonedMap);
    }

    public void put(PsiElement element, String genericName, DartClassResolveResult resolveResult) {
        this.map.put(DartGenericSpecialization.getGenericKey(element, genericName), resolveResult);
    }

    public boolean containsKey(@Nullable PsiElement element, String genericName) {
        return this.map.containsKey(DartGenericSpecialization.getGenericKey(element, genericName));
    }

    public DartClassResolveResult get(@Nullable PsiElement element, String genericName) {
        return this.map.get(DartGenericSpecialization.getGenericKey(element, genericName));
    }

    public DartGenericSpecialization getInnerSpecialization(PsiElement element) {
        String prefixToRemove = DartGenericSpecialization.getGenericKey(element, "");
        THashMap result = new THashMap();
        for (String key : this.map.keySet()) {
            DartClassResolveResult value = this.map.get(key);
            String newKey = key;
            newKey = StringUtil.trimStart((String)newKey, (String)prefixToRemove);
            result.put(newKey, value);
        }
        return new DartGenericSpecialization((Map<String, DartClassResolveResult>)result);
    }

    public static String getGenericKey(@Nullable PsiElement element, @NotNull String genericName) {
        if (genericName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericName", "com/jetbrains/lang/dart/util/DartGenericSpecialization", "getGenericKey"));
        }
        StringBuilder result = new StringBuilder();
        DartComponent dartComponent = (DartComponent)PsiTreeUtil.getParentOfType((PsiElement)element, DartComponent.class, (boolean)false);
        if (dartComponent instanceof DartClass) {
            result.append(dartComponent.getName());
        } else if (dartComponent != null) {
            DartClass dartClass = (DartClass)PsiTreeUtil.getParentOfType((PsiElement)dartComponent, DartClass.class);
            if (dartClass != null) {
                result.append(dartClass.getName());
            }
            if (PsiTreeUtil.getChildOfType((PsiElement)dartComponent, DartTypeArguments.class) != null) {
                result.append(":");
                result.append(dartComponent.getName());
            }
        }
        if (result.length() > 0) {
            result.append("-");
        }
        result.append(genericName);
        return result.toString();
    }
}

