/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.util.DartRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartNameSuggesterUtil {
    private DartNameSuggesterUtil() {
    }

    private static String deleteNonLetterFromString(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/jetbrains/lang/dart/util/DartNameSuggesterUtil", "deleteNonLetterFromString"));
        }
        Pattern pattern = Pattern.compile("[^a-zA-Z_]+");
        Matcher matcher = pattern.matcher(string);
        return matcher.replaceAll("_");
    }

    public static Collection<String> getSuggestedNames(DartExpression expression) {
        return DartNameSuggesterUtil.getSuggestedNames(expression, null);
    }

    public static Collection<String> getSuggestedNames(DartExpression expression, @Nullable Collection<String> additionalUsedNames) {
        LinkedHashSet<String> candidates = new LinkedHashSet<String>();
        String text = expression.getText();
        if (expression instanceof DartReference) {
            String dartClassName;
            DartClass dartClass = ((DartReference)expression).resolveDartClass().getDartClass();
            String string = dartClassName = dartClass == null ? null : dartClass.getName();
            if (dartClassName != null && !dartClassName.equals(StringUtil.decapitalize((String)dartClassName))) {
                candidates.add(StringUtil.decapitalize((String)dartClassName));
            }
        }
        if (expression instanceof DartCallExpression) {
            DartExpression callee = ((DartCallExpression)expression).getExpression();
            text = callee.getText();
        }
        if (text != null) {
            candidates.addAll(DartNameSuggesterUtil.generateNames(text));
        }
        Set<String> usedNames = DartRefactoringUtil.collectUsedNames((PsiElement)expression);
        if (additionalUsedNames != null && !additionalUsedNames.isEmpty()) {
            usedNames.addAll(additionalUsedNames);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String candidate : candidates) {
            int index = 0;
            String suffix = "";
            while (usedNames.contains(candidate + suffix)) {
                suffix = Integer.toString(++index);
            }
            result.add(candidate + suffix);
        }
        if (result.isEmpty()) {
            result.add("o");
        }
        return result;
    }

    @NotNull
    public static Collection<String> generateNames(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/util/DartNameSuggesterUtil", "generateNames"));
        }
        if ((name = StringUtil.decapitalize((String)DartNameSuggesterUtil.deleteNonLetterFromString(StringUtil.unquoteString((String)name.replace('.', '_'))))).startsWith("get")) {
            name = name.substring(3);
        } else if (name.startsWith("is")) {
            name = name.substring(2);
        }
        while (name.startsWith("_")) {
            name = name.substring(1);
        }
        while (name.endsWith("_")) {
            name = name.substring(0, name.length() - 1);
        }
        int length = name.length();
        LinkedHashSet<String> possibleNames = new LinkedHashSet<String>();
        for (int i = 0; i < length; ++i) {
            String candidate;
            if (!Character.isLetter(name.charAt(i)) || i != 0 && name.charAt(i - 1) != '_' && (!Character.isLowerCase(name.charAt(i - 1)) || !Character.isUpperCase(name.charAt(i))) || (candidate = StringUtil.decapitalize((String)name.substring(i))).length() >= 25) continue;
            possibleNames.add(candidate);
        }
        ArrayList reversed = new ArrayList(possibleNames);
        Collections.reverse(reversed);
        List list = ContainerUtil.map(reversed, name1 -> {
            if (name1.indexOf(95) == -1) {
                return name1;
            }
            name1 = StringUtil.capitalizeWords((String)name1, (String)"_", (boolean)true, (boolean)true);
            return StringUtil.decapitalize((String)name1.replaceAll("_", ""));
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartNameSuggesterUtil", "generateNames"));
        }
        return list;
    }
}

