/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PathUtil;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.psi.DartArguments;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartDoWhileStatement;
import com.jetbrains.lang.dart.psi.DartEnumConstantDeclaration;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartFactoryConstructorDeclaration;
import com.jetbrains.lang.dart.psi.DartFieldFormalParameter;
import com.jetbrains.lang.dart.psi.DartForStatement;
import com.jetbrains.lang.dart.psi.DartFunctionBody;
import com.jetbrains.lang.dart.psi.DartFunctionFormalParameter;
import com.jetbrains.lang.dart.psi.DartIfStatement;
import com.jetbrains.lang.dart.psi.DartLabel;
import com.jetbrains.lang.dart.psi.DartLibraryId;
import com.jetbrains.lang.dart.psi.DartLibraryStatement;
import com.jetbrains.lang.dart.psi.DartMetadata;
import com.jetbrains.lang.dart.psi.DartNamedArgument;
import com.jetbrains.lang.dart.psi.DartNamedConstructorDeclaration;
import com.jetbrains.lang.dart.psi.DartNewExpression;
import com.jetbrains.lang.dart.psi.DartNormalFormalParameter;
import com.jetbrains.lang.dart.psi.DartPartOfStatement;
import com.jetbrains.lang.dart.psi.DartPsiCompositeElement;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.DartReferenceExpression;
import com.jetbrains.lang.dart.psi.DartSimpleFormalParameter;
import com.jetbrains.lang.dart.psi.DartSimpleType;
import com.jetbrains.lang.dart.psi.DartType;
import com.jetbrains.lang.dart.psi.DartTypeArguments;
import com.jetbrains.lang.dart.psi.DartTypeParameter;
import com.jetbrains.lang.dart.psi.DartUriBasedDirective;
import com.jetbrains.lang.dart.psi.DartUriElement;
import com.jetbrains.lang.dart.psi.DartVarDeclarationListPart;
import com.jetbrains.lang.dart.psi.DartWhileStatement;
import com.jetbrains.lang.dart.psi.IDartBlock;
import com.jetbrains.lang.dart.resolve.DartPsiScopeProcessor;
import com.jetbrains.lang.dart.resolve.DartResolveProcessor;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartPsiImplUtil {
    private static final String TRIPLE_APOS = "'''";
    private static final String TRIPLE_QUOTE = "\"\"\"";
    private static final String APOS = "'";
    private static final String QUOTE = "\"";
    private static final String R_TRIPLE_APOS = "r'''";
    private static final String R_TRIPLE_QUOTE = "r\"\"\"";
    private static final String R_APOS = "r'";
    private static final String R_QUOTE = "r\"";
    private static final Key<CachedValue<PsiElement>> DART_TYPE_CACHED_RESOLVE_RESULT_KEY = Key.create((String)"DART_TYPE_CACHED_RESOLVE_RESULT_KEY");

    @NotNull
    public static String getUriString(@NotNull DartUriBasedDirective uriBasedDirective) {
        if (uriBasedDirective == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uriBasedDirective", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getUriString"));
        }
        String string = (String)DartPsiImplUtil.getUnquotedDartStringAndItsRange((String)uriBasedDirective.getUriElement().getText()).first;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getUriString"));
        }
        return string;
    }

    @NotNull
    public static Pair<String, TextRange> getUriStringAndItsRange(@NotNull DartUriElement uriElement) {
        if (uriElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uriElement", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getUriStringAndItsRange"));
        }
        Pair<String, TextRange> pair = DartPsiImplUtil.getUnquotedDartStringAndItsRange(uriElement.getText());
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getUriStringAndItsRange"));
        }
        return pair;
    }

    @NotNull
    public static Pair<String, TextRange> getUnquotedDartStringAndItsRange(@NotNull String quotedDartString) {
        int endOffset;
        int startOffset;
        if (quotedDartString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotedDartString", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getUnquotedDartStringAndItsRange"));
        }
        if (quotedDartString.startsWith(TRIPLE_APOS)) {
            startOffset = TRIPLE_APOS.length();
            endOffset = quotedDartString.endsWith(TRIPLE_APOS) && quotedDartString.length() >= TRIPLE_APOS.length() * 2 ? quotedDartString.length() - TRIPLE_APOS.length() : quotedDartString.length();
        } else if (quotedDartString.startsWith(TRIPLE_QUOTE)) {
            startOffset = TRIPLE_QUOTE.length();
            endOffset = quotedDartString.endsWith(TRIPLE_QUOTE) && quotedDartString.length() >= TRIPLE_QUOTE.length() * 2 ? quotedDartString.length() - TRIPLE_QUOTE.length() : quotedDartString.length();
        } else if (quotedDartString.startsWith(APOS)) {
            startOffset = APOS.length();
            endOffset = quotedDartString.endsWith(APOS) && quotedDartString.length() >= APOS.length() * 2 ? quotedDartString.length() - APOS.length() : quotedDartString.length();
        } else if (quotedDartString.startsWith(QUOTE)) {
            startOffset = QUOTE.length();
            endOffset = quotedDartString.endsWith(QUOTE) && quotedDartString.length() >= QUOTE.length() * 2 ? quotedDartString.length() - QUOTE.length() : quotedDartString.length();
        } else if (quotedDartString.startsWith(R_TRIPLE_APOS)) {
            startOffset = R_TRIPLE_APOS.length();
            endOffset = quotedDartString.endsWith(TRIPLE_APOS) && quotedDartString.length() >= R_TRIPLE_APOS.length() + TRIPLE_APOS.length() ? quotedDartString.length() - TRIPLE_APOS.length() : quotedDartString.length();
        } else if (quotedDartString.startsWith(R_TRIPLE_QUOTE)) {
            startOffset = R_TRIPLE_QUOTE.length();
            endOffset = quotedDartString.endsWith(TRIPLE_QUOTE) && quotedDartString.length() >= R_TRIPLE_QUOTE.length() + TRIPLE_QUOTE.length() ? quotedDartString.length() - TRIPLE_QUOTE.length() : quotedDartString.length();
        } else if (quotedDartString.startsWith(R_APOS)) {
            startOffset = R_APOS.length();
            endOffset = quotedDartString.endsWith(APOS) && quotedDartString.length() >= R_APOS.length() + APOS.length() ? quotedDartString.length() - APOS.length() : quotedDartString.length();
        } else if (quotedDartString.startsWith(R_QUOTE)) {
            startOffset = R_QUOTE.length();
            endOffset = quotedDartString.endsWith(QUOTE) && quotedDartString.length() >= R_QUOTE.length() + QUOTE.length() ? quotedDartString.length() - QUOTE.length() : quotedDartString.length();
        } else {
            startOffset = 0;
            endOffset = quotedDartString.length();
        }
        Pair pair = Pair.create((Object)quotedDartString.substring(startOffset, endOffset), (Object)TextRange.create((int)startOffset, (int)endOffset));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getUnquotedDartStringAndItsRange"));
        }
        return pair;
    }

    @NotNull
    public static String getLibraryName(@NotNull DartPartOfStatement partOfStatement) {
        DartLibraryStatement libraryStatement;
        if (partOfStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partOfStatement", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getLibraryName"));
        }
        DartLibraryId libraryId = partOfStatement.getLibraryId();
        if (libraryId != null) {
            String string = libraryId.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getLibraryName"));
            }
            return string;
        }
        DartUriElement uriElement = partOfStatement.getUriElement();
        assert (uriElement != null) : "[" + partOfStatement.toString() + "]";
        String uri = (String)uriElement.getUriStringAndItsRange().first;
        VirtualFile file = DartResolveUtil.getRealVirtualFile(partOfStatement.getContainingFile());
        VirtualFile targetFile = file == null ? null : DartResolveUtil.getImportedFile(partOfStatement.getProject(), file, uri);
        PsiFile targetPsiFile = targetFile == null || file.equals(targetFile) ? null : partOfStatement.getManager().findFile(targetFile);
        DartLibraryStatement dartLibraryStatement = libraryStatement = targetPsiFile == null ? null : (DartLibraryStatement)PsiTreeUtil.getChildOfType((PsiElement)targetPsiFile, DartLibraryStatement.class);
        if (libraryStatement != null) {
            String string = libraryStatement.getLibraryNameElement().getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getLibraryName"));
            }
            return string;
        }
        String string = PathUtil.getFileName((String)uri);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getLibraryName"));
        }
        return string;
    }

    @NotNull
    public static List<DartMetadata> getMetadataList(@NotNull DartLabel element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getMetadataList"));
        }
        List<DartMetadata> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getMetadataList"));
        }
        return list;
    }

    @NotNull
    public static List<DartMetadata> getMetadataList(@NotNull DartEnumConstantDeclaration element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getMetadataList"));
        }
        List<DartMetadata> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getMetadataList"));
        }
        return list;
    }

    @NotNull
    public static List<DartMetadata> getMetadataList(@NotNull DartVarDeclarationListPart element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getMetadataList"));
        }
        List<DartMetadata> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getMetadataList"));
        }
        return list;
    }

    @Nullable
    public static DartComponentName getComponentName(@NotNull DartNamedConstructorDeclaration element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getComponentName"));
        }
        List<DartComponentName> list = element.getComponentNameList();
        return list.size() == 2 ? list.get(1) : null;
    }

    @Nullable
    public static DartComponentName getComponentName(@NotNull DartFactoryConstructorDeclaration element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getComponentName"));
        }
        List<DartComponentName> list = element.getComponentNameList();
        return list.size() == 2 ? list.get(1) : (list.size() == 1 ? list.get(0) : null);
    }

    @Nullable
    public static DartReferenceExpression getReferenceExpression(@NotNull DartType dartType) {
        if (dartType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartType", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getReferenceExpression"));
        }
        DartSimpleType simpleType = dartType.getSimpleType();
        return simpleType == null ? null : simpleType.getReferenceExpression();
    }

    @Nullable
    public static DartTypeArguments getTypeArguments(@NotNull DartType dartType) {
        if (dartType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartType", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getTypeArguments"));
        }
        DartSimpleType simpleType = dartType.getSimpleType();
        return simpleType == null ? null : simpleType.getTypeArguments();
    }

    @Nullable
    public static PsiElement resolveReference(@NotNull DartType dartType) {
        if (dartType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartType", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "resolveReference"));
        }
        CachedValue cachedValue = (CachedValue)dartType.getUserData(DART_TYPE_CACHED_RESOLVE_RESULT_KEY);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)dartType.getProject()).createCachedValue(() -> {
                if (dartType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartType", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "lambda$resolveReference$0"));
                }
                return new CachedValueProvider.Result((Object)DartPsiImplUtil.doResolveTypeReference(dartType), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }, false);
            dartType.putUserData(DART_TYPE_CACHED_RESOLVE_RESULT_KEY, cachedValue);
        }
        return (PsiElement)cachedValue.getValue();
    }

    private static PsiElement doResolveTypeReference(DartType dartType) {
        DartReferenceExpression expression = dartType.getReferenceExpression();
        if (expression == null) {
            return null;
        }
        String typeName = expression.getText();
        if (typeName.indexOf(46) != -1) {
            return ((DartReference)expression).resolve();
        }
        ArrayList<DartComponentName> result = new ArrayList<DartComponentName>();
        DartResolveProcessor dartResolveProcessor = new DartResolveProcessor(result, typeName);
        VirtualFile virtualFile = DartResolveUtil.getRealVirtualFile(dartType.getContainingFile());
        if (virtualFile != null) {
            DartResolveUtil.processTopLevelDeclarations((PsiElement)dartType, (DartPsiScopeProcessor)dartResolveProcessor, virtualFile, typeName);
        }
        if (result.isEmpty()) {
            PsiTreeUtil.treeWalkUp((PsiScopeProcessor)dartResolveProcessor, (PsiElement)dartType, null, (ResolveState)ResolveState.initial());
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                if (((DartComponentName)iterator.next()).getParent() instanceof DartTypeParameter) continue;
                iterator.remove();
            }
        }
        if (result.isEmpty()) {
            List<VirtualFile> libraryFiles = DartResolveUtil.findLibrary(dartType.getContainingFile());
            DartResolveUtil.processTopLevelDeclarations((PsiElement)dartType, (DartPsiScopeProcessor)dartResolveProcessor, libraryFiles, typeName);
        }
        return result.isEmpty() ? null : (PsiElement)result.iterator().next();
    }

    @Nullable
    public static DartComponentName findComponentName(@NotNull DartNormalFormalParameter normalFormalParameter) {
        if (normalFormalParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "normalFormalParameter", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "findComponentName"));
        }
        DartFunctionFormalParameter functionFormalParameter = normalFormalParameter.getFunctionFormalParameter();
        DartFieldFormalParameter fieldFormalParameter = normalFormalParameter.getFieldFormalParameter();
        DartSimpleFormalParameter simpleFormalParameter = normalFormalParameter.getSimpleFormalParameter();
        if (functionFormalParameter != null) {
            return functionFormalParameter.getComponentName();
        }
        if (fieldFormalParameter != null) {
            return null;
        }
        if (simpleFormalParameter != null) {
            return simpleFormalParameter.getComponentName();
        }
        return null;
    }

    public static DartExpression getParameterReferenceExpression(DartNamedArgument argument) {
        return (DartExpression)PsiTreeUtil.getChildOfType((PsiElement)argument, DartExpression.class);
    }

    public static DartExpression getExpression(DartNamedArgument argument) {
        DartExpression[] expressions = (DartExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)argument, DartExpression.class);
        return expressions != null && expressions.length > 1 ? expressions[expressions.length - 1] : null;
    }

    @Nullable
    public static IDartBlock getBlock(DartFunctionBody functionBody) {
        return (IDartBlock)PsiTreeUtil.getChildOfType((PsiElement)functionBody, IDartBlock.class);
    }

    public static boolean isConstantObjectExpression(@NotNull DartNewExpression newExpression) {
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "isConstantObjectExpression"));
        }
        PsiElement child = newExpression.getFirstChild();
        return child != null && child.getNode().getElementType() == DartTokenTypes.CONST;
    }

    @Nullable
    public static DartArguments getArguments(@NotNull DartNewExpression newExpression) {
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getArguments"));
        }
        return (DartArguments)PsiTreeUtil.findChildOfType((PsiElement)newExpression, DartArguments.class);
    }

    @Nullable
    public static DartArguments getArguments(@NotNull DartCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getArguments"));
        }
        return (DartArguments)PsiTreeUtil.findChildOfType((PsiElement)callExpression, DartArguments.class);
    }

    @Nullable
    public static DartExpression getCondition(@NotNull DartPsiCompositeElement ifStatement) {
        if (ifStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getCondition"));
        }
        return (DartExpression)PsiTreeUtil.findChildOfType((PsiElement)ifStatement, DartExpression.class);
    }

    @Nullable
    public static PsiElement getThenBranch(@NotNull DartIfStatement ifStatement) {
        if (ifStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getThenBranch"));
        }
        return DartPsiImplUtil.getBranchAfter((PsiElement)DartPsiImplUtil.getCondition(ifStatement));
    }

    @Nullable
    public static PsiElement getElseBranch(@NotNull DartIfStatement ifStatement) {
        if (ifStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getElseBranch"));
        }
        return DartPsiImplUtil.getBranchAfter(DartPsiImplUtil.getThenBranch(ifStatement));
    }

    @Nullable
    private static PsiElement getBranchAfter(@Nullable PsiElement child) {
        return PsiTreeUtil.skipSiblingsForward((PsiElement)child, (Class[])new Class[]{LeafPsiElement.class, PsiWhiteSpace.class, PsiComment.class});
    }

    @Nullable
    public static PsiElement getDoBody(@NotNull DartDoWhileStatement doStatement) {
        if (doStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doStatement", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getDoBody"));
        }
        return DartPsiImplUtil.getBranchAfter((PsiElement)doStatement);
    }

    @Nullable
    public static PsiElement getForBody(@NotNull DartForStatement forStatement) {
        if (forStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forStatement", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getForBody"));
        }
        return forStatement.getLastChild();
    }

    @Nullable
    public static PsiElement getWhileBody(@NotNull DartWhileStatement whileStatement) {
        if (whileStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whileStatement", "com/jetbrains/lang/dart/util/DartPsiImplUtil", "getWhileBody"));
        }
        return DartPsiImplUtil.getBranchAfter((PsiElement)DartPsiImplUtil.getCondition(whileStatement));
    }
}

