/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.util;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartExpressionList;
import com.jetbrains.lang.dart.psi.DartNamedArgument;
import com.jetbrains.lang.dart.psi.DartRecursiveVisitor;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.DartStatements;
import com.jetbrains.lang.dart.resolve.ComponentNameScopeProcessor;
import com.jetbrains.lang.dart.util.UsefulPsiTreeUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartRefactoringUtil {
    public static Set<String> collectUsedNames(PsiElement context) {
        return new THashSet((Collection)ContainerUtil.map(DartRefactoringUtil.collectUsedComponents(context), NavigationItem::getName));
    }

    public static Set<DartComponentName> collectUsedComponents(PsiElement context) {
        THashSet usedComponentNames = new THashSet();
        PsiTreeUtil.treeWalkUp((PsiScopeProcessor)new ComponentNameScopeProcessor((Set<DartComponentName>)usedComponentNames), (PsiElement)context, null, (ResolveState)ResolveState.initial());
        return usedComponentNames;
    }

    @Nullable
    public static DartExpression getSelectedExpression(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/util/DartRefactoringUtil", "getSelectedExpression"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/util/DartRefactoringUtil", "getSelectedExpression"));
        }
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "com/jetbrains/lang/dart/util/DartRefactoringUtil", "getSelectedExpression"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "com/jetbrains/lang/dart/util/DartRefactoringUtil", "getSelectedExpression"));
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent == null) {
            return null;
        }
        if (parent instanceof DartExpression) {
            return (DartExpression)parent;
        }
        return (DartExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, DartExpression.class);
    }

    @NotNull
    public static List<PsiElement> getOccurrences(final @NotNull PsiElement pattern, @Nullable PsiElement context) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/jetbrains/lang/dart/util/DartRefactoringUtil", "getOccurrences"));
        }
        if (context == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartRefactoringUtil", "getOccurrences"));
            }
            return list;
        }
        final ArrayList<PsiElement> occurrences = new ArrayList<PsiElement>();
        context.acceptChildren((PsiElementVisitor)new DartRecursiveVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/util/DartRefactoringUtil$1", "visitElement"));
                }
                if (DartComponentType.typeOf(element) == DartComponentType.PARAMETER) {
                    return;
                }
                if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)element, (PsiElement)pattern)) {
                    occurrences.add(element);
                    return;
                }
                super.visitElement(element);
            }
        });
        ArrayList<PsiElement> arrayList = occurrences;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartRefactoringUtil", "getOccurrences"));
        }
        return arrayList;
    }

    @NotNull
    public static PsiElement[] findStatementsInRange(PsiFile file, int startOffset, int endOffset) {
        PsiElement commonParent;
        PsiElement element1 = file.findElementAt(startOffset);
        PsiElement element2 = file.findElementAt(endOffset - 1);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file.findElementAt(startOffset);
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file.findElementAt(endOffset - 1);
        }
        if (element1 != null && element2 != null && (commonParent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2)) instanceof DartExpression) {
            PsiElement[] psiElementArray = new PsiElement[]{commonParent};
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartRefactoringUtil", "findStatementsInRange"));
            }
            return psiElementArray;
        }
        DartStatements statements = (DartStatements)PsiTreeUtil.getParentOfType((PsiElement)element1, DartStatements.class);
        if (statements == null || element2 == null || !PsiTreeUtil.isAncestor((PsiElement)statements, (PsiElement)element2, (boolean)true)) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartRefactoringUtil", "findStatementsInRange"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        Object[] astResult = UsefulPsiTreeUtil.findChildrenRange(statements.getNode().getChildren(null), startOffset, endOffset);
        PsiElement[] psiElementArray = (PsiElement[])ContainerUtil.map2Array((Object[])astResult, PsiElement.class, ASTNode::getPsi);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartRefactoringUtil", "findStatementsInRange"));
        }
        return psiElementArray;
    }

    @Nullable
    public static DartExpression findExpressionInRange(PsiFile file, int startOffset, int endOffset) {
        DartExpression expression;
        PsiElement element1 = file.findElementAt(startOffset);
        PsiElement element2 = file.findElementAt(endOffset - 1);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
        }
        if ((expression = (DartExpression)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)startOffset, (int)endOffset, DartExpression.class)) == null || expression.getTextRange().getEndOffset() != endOffset) {
            return null;
        }
        if (expression instanceof DartReference && expression.getParent() instanceof DartCallExpression) {
            return null;
        }
        return expression;
    }

    @NotNull
    public static PsiElement[] findListExpressionInRange(@NotNull PsiFile file, int startOffset, int endOffset) {
        DartExpression expression;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/util/DartRefactoringUtil", "findListExpressionInRange"));
        }
        PsiElement element1 = file.findElementAt(startOffset);
        PsiElement element2 = file.findElementAt(endOffset - 1);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
        }
        if ((expression = (DartExpression)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)startOffset, (int)endOffset, DartExpression.class)) == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartRefactoringUtil", "findListExpressionInRange"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (expression.getTextRange().getEndOffset() != endOffset) {
            element2 = file.findElementAt(endOffset - 1);
            if (element2 != null && DartRefactoringUtil.isComma(element2)) {
                PsiElement prev = UsefulPsiTreeUtil.getPrevSiblingSkipWhiteSpacesAndComments(element2, true);
                if (prev instanceof DartExpressionList) {
                    prev = prev.getLastChild();
                } else if (prev instanceof DartNamedArgument && prev == expression.getParent()) {
                    PsiElement[] psiElementArray = new PsiElement[]{prev, element2};
                    if (psiElementArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartRefactoringUtil", "findListExpressionInRange"));
                    }
                    return psiElementArray;
                }
                if (prev == expression) {
                    PsiElement[] psiElementArray = new PsiElement[]{expression, element2};
                    if (psiElementArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartRefactoringUtil", "findListExpressionInRange"));
                    }
                    return psiElementArray;
                }
                if (PsiElement.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartRefactoringUtil", "findListExpressionInRange"));
                }
                return PsiElement.EMPTY_ARRAY;
            }
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartRefactoringUtil", "findListExpressionInRange"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = new PsiElement[]{expression};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartRefactoringUtil", "findListExpressionInRange"));
        }
        return psiElementArray;
    }

    public static boolean isRightBracket(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/util/DartRefactoringUtil", "isRightBracket"));
        }
        return element.getNode().getElementType() == DartTokenTypes.RBRACKET;
    }

    public static boolean isRightParen(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/util/DartRefactoringUtil", "isRightParen"));
        }
        return element.getNode().getElementType() == DartTokenTypes.RPAREN;
    }

    public static boolean isComma(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/util/DartRefactoringUtil", "isComma"));
        }
        return element.getNode().getElementType() == DartTokenTypes.COMMA;
    }
}

