/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.util;

import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.BooleanValueHolder;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.DartTokenTypesSets;
import com.jetbrains.lang.dart.ide.index.DartComponentIndex;
import com.jetbrains.lang.dart.ide.index.DartImportAndExportIndex;
import com.jetbrains.lang.dart.ide.index.DartImportOrExportInfo;
import com.jetbrains.lang.dart.ide.index.DartLibraryIndex;
import com.jetbrains.lang.dart.ide.index.DartPartUriIndex;
import com.jetbrains.lang.dart.ide.info.DartFunctionDescription;
import com.jetbrains.lang.dart.ide.info.DartParameterInfoHandler;
import com.jetbrains.lang.dart.psi.DartArgumentList;
import com.jetbrains.lang.dart.psi.DartAssignmentOperator;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartCascadeReferenceExpression;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartClassBody;
import com.jetbrains.lang.dart.psi.DartClassDefinition;
import com.jetbrains.lang.dart.psi.DartClassMembers;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartDefaultFormalNamedParameter;
import com.jetbrains.lang.dart.psi.DartEmbeddedContent;
import com.jetbrains.lang.dart.psi.DartEnumConstantDeclaration;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartFieldFormalParameter;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.psi.DartForInPart;
import com.jetbrains.lang.dart.psi.DartFormalParameterList;
import com.jetbrains.lang.dart.psi.DartFunctionBody;
import com.jetbrains.lang.dart.psi.DartFunctionDeclarationWithBodyOrNative;
import com.jetbrains.lang.dart.psi.DartFunctionExpression;
import com.jetbrains.lang.dart.psi.DartFunctionExpressionBody;
import com.jetbrains.lang.dart.psi.DartFunctionFormalParameter;
import com.jetbrains.lang.dart.psi.DartLibraryStatement;
import com.jetbrains.lang.dart.psi.DartMethodDeclaration;
import com.jetbrains.lang.dart.psi.DartNewExpression;
import com.jetbrains.lang.dart.psi.DartNormalFormalParameter;
import com.jetbrains.lang.dart.psi.DartOptionalFormalParameters;
import com.jetbrains.lang.dart.psi.DartPartOfStatement;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.DartReferenceExpression;
import com.jetbrains.lang.dart.psi.DartReturnType;
import com.jetbrains.lang.dart.psi.DartSimpleFormalParameter;
import com.jetbrains.lang.dart.psi.DartType;
import com.jetbrains.lang.dart.psi.DartTypeList;
import com.jetbrains.lang.dart.psi.DartValueExpression;
import com.jetbrains.lang.dart.psi.DartVarAccessDeclaration;
import com.jetbrains.lang.dart.psi.DartVarDeclarationList;
import com.jetbrains.lang.dart.psi.DartVarDeclarationListPart;
import com.jetbrains.lang.dart.psi.DartVarInit;
import com.jetbrains.lang.dart.psi.impl.AbstractDartPsiClass;
import com.jetbrains.lang.dart.psi.impl.DartPsiCompositeElementImpl;
import com.jetbrains.lang.dart.resolve.DartPsiScopeProcessor;
import com.jetbrains.lang.dart.resolve.DartResolveProcessor;
import com.jetbrains.lang.dart.util.DartClassResolveResult;
import com.jetbrains.lang.dart.util.DartGenericSpecialization;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import com.jetbrains.lang.dart.util.UsefulPsiTreeUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartResolveUtil {
    public static final String OBJECT = "Object";

    public static List<PsiElement> findDartRoots(@Nullable PsiFile psiFile) {
        if (psiFile instanceof XmlFile) {
            return DartResolveUtil.findDartRootsInXml((XmlFile)psiFile);
        }
        return psiFile instanceof DartFile ? Collections.singletonList(psiFile) : Collections.emptyList();
    }

    private static List<PsiElement> findDartRootsInXml(XmlFile xmlFile) {
        final ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        xmlFile.acceptChildren((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof DartEmbeddedContent) {
                    result.add(element);
                    return;
                }
                super.visitElement(element);
            }
        });
        return result;
    }

    public static boolean isLValue(PsiElement element) {
        if (element instanceof PsiFile) {
            return false;
        }
        PsiElement nextSibling = UsefulPsiTreeUtil.getNextSiblingSkippingWhiteSpacesAndComments(element);
        while (nextSibling == null && element != null) {
            element = element.getParent();
            nextSibling = UsefulPsiTreeUtil.getNextSiblingSkippingWhiteSpacesAndComments(element);
        }
        if (nextSibling instanceof LeafPsiElement) {
            return DartTokenTypesSets.ASSIGNMENT_OPERATORS.contains(((LeafPsiElement)nextSibling).getElementType());
        }
        return nextSibling instanceof DartAssignmentOperator;
    }

    public static boolean checkParametersType(DartFormalParameterList list, DartClass ... classes) {
        int i;
        List<DartNormalFormalParameter> normalFormalParameterList = list.getNormalFormalParameterList();
        int size = normalFormalParameterList.size();
        for (i = 0; i < size; ++i) {
            if (i >= classes.length) {
                return false;
            }
            DartNormalFormalParameter normalFormalParameter = normalFormalParameterList.get(i);
            DartType dartType = DartResolveUtil.findType((PsiElement)normalFormalParameter);
            if (dartType == null || DartResolveUtil.canAssign(DartResolveUtil.resolveClassByType(dartType).getDartClass(), classes[i])) continue;
            return false;
        }
        DartOptionalFormalParameters optionalFormalParameters = list.getOptionalFormalParameters();
        if (optionalFormalParameters == null) {
            return true;
        }
        int size2 = optionalFormalParameters.getDefaultFormalNamedParameterList().size();
        while (i - normalFormalParameterList.size() < size2) {
            DartDefaultFormalNamedParameter defaultFormalParameter = optionalFormalParameters.getDefaultFormalNamedParameterList().get(i - normalFormalParameterList.size());
            DartType dartType = DartResolveUtil.findType((PsiElement)defaultFormalParameter.getNormalFormalParameter());
            if (dartType != null && !DartResolveUtil.canAssign(DartResolveUtil.resolveClassByType(dartType).getDartClass(), classes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean canAssign(final @Nullable DartClass baseClass, @Nullable DartClass aClass) {
        if (baseClass == null || aClass == null) {
            return true;
        }
        final BooleanValueHolder result = new BooleanValueHolder(false);
        DartResolveUtil.processSuperClasses(new PsiElementProcessor<DartClass>(){

            public boolean execute(@NotNull DartClass dartClass) {
                if (dartClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/util/DartResolveUtil$2", "execute"));
                }
                if (dartClass == baseClass) {
                    result.setValue(true);
                    return false;
                }
                return true;
            }
        }, aClass);
        return result.getValue();
    }

    @Nullable
    public static DartType findType(@Nullable PsiElement element) {
        if (element instanceof DartDefaultFormalNamedParameter) {
            return DartResolveUtil.findType((PsiElement)((DartDefaultFormalNamedParameter)element).getNormalFormalParameter());
        }
        if (element instanceof DartNormalFormalParameter) {
            DartFunctionFormalParameter functionFormalParameter = ((DartNormalFormalParameter)element).getFunctionFormalParameter();
            DartFieldFormalParameter fieldFormalParameter = ((DartNormalFormalParameter)element).getFieldFormalParameter();
            DartSimpleFormalParameter simpleFormalParameter = ((DartNormalFormalParameter)element).getSimpleFormalParameter();
            if (functionFormalParameter != null) {
                // empty if block
            }
            if (fieldFormalParameter != null) {
                return fieldFormalParameter.getType();
            }
            if (simpleFormalParameter != null) {
                return simpleFormalParameter.getType();
            }
        }
        return null;
    }

    @NotNull
    public static DartClassResolveResult findCoreClass(PsiElement context, String className) {
        VirtualFile dartCoreLib = DartLibraryIndex.getSdkLibByUri(context.getProject(), "dart:core");
        ArrayList<DartComponentName> result = new ArrayList<DartComponentName>();
        DartResolveUtil.processTopLevelDeclarations(context, (DartPsiScopeProcessor)new DartResolveProcessor(result, className), dartCoreLib, className);
        PsiElement parent = result.isEmpty() ? null : ((DartComponentName)result.iterator().next()).getParent();
        DartClassResolveResult dartClassResolveResult = DartClassResolveResult.create(parent instanceof DartClass ? (DartClass)parent : null);
        if (dartClassResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "findCoreClass"));
        }
        return dartClassResolveResult;
    }

    @NotNull
    public static String getLibraryName(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/lang/dart/util/DartResolveUtil", "getLibraryName"));
        }
        for (PsiElement root : DartResolveUtil.findDartRoots(psiFile)) {
            DartLibraryStatement libraryStatement = (DartLibraryStatement)PsiTreeUtil.getChildOfType((PsiElement)root, DartLibraryStatement.class);
            if (libraryStatement != null) {
                String string = libraryStatement.getLibraryNameElement().getName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "getLibraryName"));
                }
                return string;
            }
            DartPartOfStatement partOfStatement = (DartPartOfStatement)PsiTreeUtil.getChildOfType((PsiElement)root, DartPartOfStatement.class);
            if (partOfStatement == null) continue;
            String string = partOfStatement.getLibraryName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "getLibraryName"));
            }
            return string;
        }
        String string = psiFile.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "getLibraryName"));
        }
        return string;
    }

    @NotNull
    public static Collection<DartClass> getClassDeclarations(@NotNull PsiElement root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/jetbrains/lang/dart/util/DartResolveUtil", "getClassDeclarations"));
        }
        SmartList result = new SmartList();
        for (PsiElement child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof DartClass)) continue;
            result.add((DartClass)child);
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "getClassDeclarations"));
        }
        return smartList;
    }

    public static void processTopLevelDeclarations(@NotNull PsiElement context, @NotNull DartPsiScopeProcessor processor, @NotNull List<VirtualFile> files, @Nullable String componentNameHint) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/lang/dart/util/DartResolveUtil", "processTopLevelDeclarations"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/lang/dart/util/DartResolveUtil", "processTopLevelDeclarations"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/lang/dart/util/DartResolveUtil", "processTopLevelDeclarations"));
        }
        for (VirtualFile virtualFile : files) {
            if (!DartResolveUtil.processTopLevelDeclarations(context, processor, virtualFile, componentNameHint)) break;
        }
    }

    public static boolean processTopLevelDeclarations(@NotNull PsiElement context, @NotNull DartPsiScopeProcessor processor, @Nullable VirtualFile rootVirtualFile, @Nullable String componentNameHint) {
        Set filesOfInterest;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/lang/dart/util/DartResolveUtil", "processTopLevelDeclarations"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/lang/dart/util/DartResolveUtil", "processTopLevelDeclarations"));
        }
        Set set = filesOfInterest = componentNameHint == null ? null : (Set)DartComponentIndex.getAllFiles(componentNameHint, context.getResolveScope());
        if (filesOfInterest != null && filesOfInterest.isEmpty()) {
            return true;
        }
        boolean privateOnly = componentNameHint != null && componentNameHint.startsWith("_");
        return DartResolveUtil.processTopLevelDeclarationsImpl(context, processor, rootVirtualFile, filesOfInterest, (Set<VirtualFile>)new THashSet(), privateOnly);
    }

    private static boolean processTopLevelDeclarationsImpl(@NotNull PsiElement context, @NotNull DartPsiScopeProcessor processor, @Nullable VirtualFile virtualFile, @Nullable Set<VirtualFile> filesOfInterest, @NotNull Set<VirtualFile> alreadyProcessed, boolean privateOnly) {
        VirtualFile dartCoreLib;
        boolean contains;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/lang/dart/util/DartResolveUtil", "processTopLevelDeclarationsImpl"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/lang/dart/util/DartResolveUtil", "processTopLevelDeclarationsImpl"));
        }
        if (alreadyProcessed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alreadyProcessed", "com/jetbrains/lang/dart/util/DartResolveUtil", "processTopLevelDeclarationsImpl"));
        }
        if (virtualFile == null) {
            return true;
        }
        if (alreadyProcessed.contains(virtualFile)) {
            processor.processFilteredOutElementsForImportedFile(virtualFile);
            return true;
        }
        alreadyProcessed.add(virtualFile);
        boolean bl = contains = filesOfInterest == null || filesOfInterest.contains(virtualFile);
        if (contains) {
            PsiFile psiFile = context.getManager().findFile(virtualFile);
            for (PsiElement root : DartResolveUtil.findDartRoots(psiFile)) {
                if (DartPsiCompositeElementImpl.processDeclarationsImpl(root, processor, ResolveState.initial(), null)) continue;
                return false;
            }
        }
        for (String partUrl : DartPartUriIndex.getPartUris(context.getProject(), virtualFile)) {
            PsiFile partPsiFile;
            VirtualFile partFile = DartResolveUtil.getImportedFile(context.getProject(), virtualFile, partUrl);
            if (partFile == null || alreadyProcessed.contains(partFile) || filesOfInterest != null && !filesOfInterest.contains(partFile) || (partPsiFile = context.getManager().findFile(partFile)) == null || DartResolveUtil.processTopLevelDeclarationsImpl((PsiElement)partPsiFile, processor, partFile, filesOfInterest, alreadyProcessed, privateOnly)) continue;
            return false;
        }
        if (privateOnly) {
            return true;
        }
        List<VirtualFile> libraryFiles = DartResolveUtil.findLibrary(context.getContainingFile());
        boolean processingLibraryWhereContextElementLocated = libraryFiles.contains(virtualFile);
        boolean coreImportedExplicitly = false;
        for (DartImportOrExportInfo importOrExportInfo : DartImportAndExportIndex.getImportAndExportInfos(context.getProject(), virtualFile)) {
            VirtualFile importedFile;
            if (processingLibraryWhereContextElementLocated && importOrExportInfo.getKind() == DartImportOrExportInfo.Kind.Export || !processingLibraryWhereContextElementLocated && importOrExportInfo.getKind() == DartImportOrExportInfo.Kind.Import) continue;
            if (importOrExportInfo.getKind() == DartImportOrExportInfo.Kind.Import && "dart:core".equals(importOrExportInfo.getUri())) {
                coreImportedExplicitly = true;
            }
            if (importOrExportInfo.getKind() == DartImportOrExportInfo.Kind.Import && importOrExportInfo.getImportPrefix() != null || (importedFile = DartResolveUtil.getImportedFile(context.getProject(), virtualFile, importOrExportInfo.getUri())) == null) continue;
            processor.importedFileProcessingStarted(importedFile, importOrExportInfo);
            boolean continueProcessing = DartResolveUtil.processTopLevelDeclarationsImpl(context, processor, importedFile, filesOfInterest, alreadyProcessed, false);
            processor.importedFileProcessingFinished(importedFile);
            if (continueProcessing) continue;
            return false;
        }
        if (!coreImportedExplicitly && processingLibraryWhereContextElementLocated && (dartCoreLib = DartLibraryIndex.getSdkLibByUri(context.getProject(), "dart:core")) != null) {
            DartImportOrExportInfo implicitImportInfo = new DartImportOrExportInfo(DartImportOrExportInfo.Kind.Import, "dart:core", null, Collections.emptySet(), Collections.emptySet());
            processor.importedFileProcessingStarted(dartCoreLib, implicitImportInfo);
            boolean continueProcessing = DartResolveUtil.processTopLevelDeclarationsImpl(context, processor, dartCoreLib, filesOfInterest, alreadyProcessed, false);
            processor.importedFileProcessingFinished(dartCoreLib);
            if (!continueProcessing) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static VirtualFile getImportedFile(@NotNull Project project, @NotNull VirtualFile contextFile, @NotNull String importText) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/util/DartResolveUtil", "getImportedFile"));
        }
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFile", "com/jetbrains/lang/dart/util/DartResolveUtil", "getImportedFile"));
        }
        if (importText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importText", "com/jetbrains/lang/dart/util/DartResolveUtil", "getImportedFile"));
        }
        if (importText.startsWith("dart:") || importText.startsWith("package:") || importText.startsWith("file:")) {
            return DartUrlResolver.getInstance(project, contextFile).findFileByDartUrl(importText);
        }
        VirtualFile parent = contextFile.getParent();
        return parent == null ? null : VfsUtilCore.findRelativeFile((String)importText, (VirtualFile)parent);
    }

    @Nullable
    public static VirtualFile getRealVirtualFile(PsiFile psiFile) {
        return psiFile != null ? psiFile.getOriginalFile().getVirtualFile() : null;
    }

    public static boolean sameLibrary(@NotNull PsiElement context1, @NotNull PsiElement context2) {
        if (context1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context1", "com/jetbrains/lang/dart/util/DartResolveUtil", "sameLibrary"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context2", "com/jetbrains/lang/dart/util/DartResolveUtil", "sameLibrary"));
        }
        List<VirtualFile> librariesForContext1 = DartResolveUtil.findLibrary(context1.getContainingFile());
        if (librariesForContext1.isEmpty()) {
            return false;
        }
        List<VirtualFile> librariesForContext2 = DartResolveUtil.findLibrary(context2.getContainingFile());
        if (librariesForContext2.isEmpty()) {
            return false;
        }
        THashSet librariesSetForContext1 = new THashSet(librariesForContext1);
        return ContainerUtil.find(librariesForContext2, file -> librariesSetForContext1.contains(file)) != null;
    }

    @NotNull
    public static List<VirtualFile> findLibrary(@NotNull PsiFile context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/lang/dart/util/DartResolveUtil", "findLibrary"));
        }
        VirtualFile contextVirtualFile = DartResolveUtil.getRealVirtualFile(context);
        if (contextVirtualFile == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "findLibrary"));
            }
            return list;
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)context, () -> {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/lang/dart/util/DartResolveUtil", "lambda$findLibrary$1"));
            }
            for (PsiElement root : DartResolveUtil.findDartRoots(context)) {
                String libraryName;
                List<VirtualFile> files;
                DartPartOfStatement partOfStatement = (DartPartOfStatement)PsiTreeUtil.getChildOfType((PsiElement)root, DartPartOfStatement.class);
                if (partOfStatement == null || (files = DartResolveUtil.findLibraryByName((PsiElement)context, libraryName = partOfStatement.getLibraryName())).isEmpty()) continue;
                return new CachedValueProvider.Result(files, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            return new CachedValueProvider.Result(Collections.singletonList(contextVirtualFile), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "findLibrary"));
        }
        return list;
    }

    @NotNull
    public static List<VirtualFile> findLibraryByName(@NotNull PsiElement context, @NotNull String libraryName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/lang/dart/util/DartResolveUtil", "findLibraryByName"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/jetbrains/lang/dart/util/DartResolveUtil", "findLibraryByName"));
        }
        List list = ContainerUtil.filter(DartLibraryIndex.getFilesByLibName(context.getResolveScope(), libraryName), mainLibFile -> {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/lang/dart/util/DartResolveUtil", "lambda$findLibraryByName$2"));
            }
            for (String partUrl : DartPartUriIndex.getPartUris(context.getProject(), mainLibFile)) {
                VirtualFile partFile = DartResolveUtil.getImportedFile(context.getProject(), mainLibFile, partUrl);
                if (!Comparing.equal((Object)DartResolveUtil.getRealVirtualFile(context.getContainingFile()), (Object)partFile)) continue;
                return true;
            }
            return false;
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "findLibraryByName"));
        }
        return list;
    }

    public static boolean isLibraryRoot(PsiFile psiFile) {
        for (PsiElement root : DartResolveUtil.findDartRoots(psiFile)) {
            if (PsiTreeUtil.getChildOfType((PsiElement)root, DartPartOfStatement.class) == null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static DartFunctionDeclarationWithBodyOrNative getMainFunction(@Nullable PsiFile file) {
        if (!(file instanceof DartFile)) {
            return null;
        }
        ArrayList<DartComponentName> result = new ArrayList<DartComponentName>();
        DartPsiCompositeElementImpl.processDeclarationsImpl((PsiElement)file, new DartResolveProcessor(result, "main"), ResolveState.initial(), null);
        for (DartComponentName componentName : result) {
            PsiElement parent = componentName.getParent();
            if (!(parent instanceof DartFunctionDeclarationWithBodyOrNative)) continue;
            return (DartFunctionDeclarationWithBodyOrNative)parent;
        }
        return null;
    }

    @Nullable
    public static DartReference getLeftReference(@Nullable PsiElement node) {
        if (node == null) {
            return null;
        }
        PsiElement sibling = UsefulPsiTreeUtil.getPrevSiblingSkipWhiteSpacesAndComments(node, true);
        while (sibling != null) {
            String siblingText = sibling.getText();
            if (!(".".equals(siblingText) || "..".equals(siblingText) || "?.".equals(siblingText))) {
                Object candidate = sibling;
                if (candidate instanceof DartType) {
                    candidate = ((DartType)sibling).getReferenceExpression();
                }
                return candidate instanceof DartReference && candidate != node ? (DartReference)candidate : null;
            }
            sibling = UsefulPsiTreeUtil.getPrevSiblingSkipWhiteSpacesAndComments(sibling, true);
        }
        DartReference reference = (DartReference)PsiTreeUtil.getParentOfType((PsiElement)node, DartReference.class, (boolean)false);
        while (reference != null) {
            PsiElement parent = reference.getParent();
            if (parent instanceof DartCascadeReferenceExpression) {
                if ((parent = parent.getParent()) instanceof DartValueExpression) {
                    DartExpression firstExpression;
                    List<DartExpression> expressionList = ((DartValueExpression)parent).getExpressionList();
                    DartExpression dartExpression = firstExpression = expressionList.isEmpty() ? null : expressionList.get(0);
                    if (firstExpression instanceof DartReference) {
                        return (DartReference)firstExpression;
                    }
                }
                return null;
            }
            if (!(parent instanceof DartReference) || parent.getFirstChild() != reference) break;
            reference = (DartReference)parent;
        }
        return null;
    }

    @NotNull
    public static List<DartComponent> findNamedSubComponents(DartClass ... rootDartClasses) {
        if (rootDartClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDartClasses", "com/jetbrains/lang/dart/util/DartResolveUtil", "findNamedSubComponents"));
        }
        List<DartComponent> list = DartResolveUtil.findNamedSubComponents(true, rootDartClasses);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "findNamedSubComponents"));
        }
        return list;
    }

    @NotNull
    public static List<DartComponent> findNamedSubComponents(boolean unique, DartClass ... rootDartClasses) {
        if (rootDartClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDartClasses", "com/jetbrains/lang/dart/util/DartResolveUtil", "findNamedSubComponents"));
        }
        List<DartComponent> unfilteredResult = DartResolveUtil.findSubComponents(dartClass -> {
            ArrayList<DartComponent> result = new ArrayList<DartComponent>();
            for (DartComponent namedComponent : DartResolveUtil.getNamedSubComponents(dartClass)) {
                if (namedComponent.getName() == null) continue;
                result.add(namedComponent);
            }
            return result;
        }, rootDartClasses);
        if (!unique) {
            List<DartComponent> list = unfilteredResult;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "findNamedSubComponents"));
            }
            return list;
        }
        ArrayList<DartComponent> arrayList = new ArrayList<DartComponent>(DartResolveUtil.namedComponentToMap(unfilteredResult).values());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "findNamedSubComponents"));
        }
        return arrayList;
    }

    public static List<DartMethodDeclaration> findOperators(AbstractDartPsiClass dartPsiClass) {
        return DartResolveUtil.findSubComponents(dartClass -> {
            ArrayList operators = Lists.newArrayList();
            DartMethodDeclaration[] methods = (DartMethodDeclaration[])PsiTreeUtil.getChildrenOfType((PsiElement)DartResolveUtil.getBody(dartClass), DartMethodDeclaration.class);
            if (methods != null) {
                for (DartMethodDeclaration method : methods) {
                    if (!method.isOperator()) continue;
                    operators.add(method);
                }
            }
            return operators;
        }, dartPsiClass);
    }

    @NotNull
    public static <T> List<T> findSubComponents(final Function<DartClass, List<T>> fun, DartClass ... rootDartClasses) {
        if (rootDartClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDartClasses", "com/jetbrains/lang/dart/util/DartResolveUtil", "findSubComponents"));
        }
        final ArrayList unfilteredResult = new ArrayList();
        DartResolveUtil.processSuperClasses(new PsiElementProcessor<DartClass>(){

            public boolean execute(@NotNull DartClass dartClass) {
                if (dartClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/util/DartResolveUtil$3", "execute"));
                }
                unfilteredResult.addAll((Collection)fun.fun((Object)dartClass));
                return true;
            }
        }, rootDartClasses);
        ArrayList arrayList = unfilteredResult;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "findSubComponents"));
        }
        return arrayList;
    }

    public static boolean processSuperClasses(PsiElementProcessor<DartClass> processor, DartClass ... rootDartClasses) {
        if (rootDartClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDartClasses", "com/jetbrains/lang/dart/util/DartResolveUtil", "processSuperClasses"));
        }
        THashSet processedClasses = new THashSet();
        LinkedList<DartClass> classes = new LinkedList<DartClass>();
        classes.addAll(Arrays.asList(rootDartClasses));
        while (!classes.isEmpty()) {
            DartClass dartClass = (DartClass)classes.pollFirst();
            if (dartClass == null || processedClasses.contains(dartClass)) continue;
            if (!processor.execute((PsiElement)dartClass)) {
                return false;
            }
            ContainerUtil.addIfNotNull(classes, (Object)dartClass.getSuperClassResolvedOrObjectClass().getDartClass());
            for (DartType type : DartResolveUtil.getImplementsAndMixinsList(dartClass)) {
                ContainerUtil.addIfNotNull(classes, (Object)DartResolveUtil.resolveClassByType(type).getDartClass());
            }
            processedClasses.add(dartClass);
        }
        return true;
    }

    public static void collectSupers(final @NotNull List<DartClass> superClasses, final @NotNull List<DartClass> superInterfaces, @Nullable DartClass rootDartClass) {
        if (superClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClasses", "com/jetbrains/lang/dart/util/DartResolveUtil", "collectSupers"));
        }
        if (superInterfaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superInterfaces", "com/jetbrains/lang/dart/util/DartResolveUtil", "collectSupers"));
        }
        DartResolveUtil.processSupers(new PsiElementProcessor<DartClass>(){

            public boolean execute(@NotNull DartClass dartClass) {
                if (dartClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/util/DartResolveUtil$4", "execute"));
                }
                superClasses.add(dartClass);
                return true;
            }
        }, new PsiElementProcessor<DartClass>(){

            public boolean execute(@NotNull DartClass dartClass) {
                if (dartClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/util/DartResolveUtil$5", "execute"));
                }
                superInterfaces.add(dartClass);
                return true;
            }
        }, rootDartClass);
    }

    public static void processSupers(@Nullable PsiElementProcessor<DartClass> superClassProcessor, @Nullable PsiElementProcessor<DartClass> superInterfaceProcessor, @Nullable DartClass rootDartClass) {
        THashSet processedClasses = new THashSet();
        DartClass currentClass = rootDartClass;
        while (currentClass != null) {
            DartClass result;
            processedClasses.add(currentClass);
            for (DartType type : currentClass.getImplementsList()) {
                result = DartResolveUtil.resolveClassByType(type).getDartClass();
                if (superInterfaceProcessor == null || result == null || processedClasses.contains(result)) continue;
                if (!superInterfaceProcessor.execute((PsiElement)result)) {
                    return;
                }
                if (DartResolveUtil.processSuperClasses(superInterfaceProcessor, result)) continue;
                return;
            }
            for (DartType type : currentClass.getMixinsList()) {
                result = DartResolveUtil.resolveClassByType(type).getDartClass();
                if (superClassProcessor == null || result == null || processedClasses.contains(result) || superClassProcessor.execute((PsiElement)result)) continue;
                return;
            }
            if ((currentClass = currentClass.getSuperClassResolvedOrObjectClass().getDartClass()) == null || processedClasses.contains(currentClass)) break;
            if (superClassProcessor == null || superClassProcessor.execute((PsiElement)currentClass)) continue;
            return;
        }
    }

    public static Map<Pair<String, Boolean>, DartComponent> namedComponentToMap(List<DartComponent> unfilteredResult) {
        HashMap<Pair<String, Boolean>, DartComponent> result = new HashMap<Pair<String, Boolean>, DartComponent>();
        for (DartComponent dartComponent : unfilteredResult) {
            Pair key = Pair.create((Object)dartComponent.getName(), (Object)dartComponent.isGetter());
            if (result.containsKey(key)) continue;
            result.put((Pair<String, Boolean>)key, dartComponent);
        }
        return result;
    }

    public static List<DartComponentName> getComponentNames(List<? extends DartComponent> fields) {
        return ContainerUtil.filter((Collection)ContainerUtil.map(fields, component -> component.getComponentName()), (Condition)Condition.NOT_NULL);
    }

    public static DartComponentName[] getComponentNameArray(List<? extends DartComponent> components) {
        List<DartComponentName> names = DartResolveUtil.getComponentNames(components);
        return names.toArray(new DartComponentName[names.size()]);
    }

    @NotNull
    public static List<DartComponent> getNamedSubComponents(DartClass dartClass) {
        if (dartClass.isEnum()) {
            List<DartEnumConstantDeclaration> enumConstants = dartClass.getEnumConstantDeclarationList();
            ArrayList<DartComponent> result = new ArrayList<DartComponent>(enumConstants.size());
            for (DartEnumConstantDeclaration constant : enumConstants) {
                result.add(constant);
            }
            ArrayList<DartComponent> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "getNamedSubComponents"));
            }
            return arrayList;
        }
        DartClassMembers body = DartResolveUtil.getBody(dartClass);
        ArrayList<DartComponent> result = new ArrayList<DartComponent>();
        if (body == null) {
            ArrayList<DartComponent> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "getNamedSubComponents"));
            }
            return arrayList;
        }
        Object[] namedComponents = (DartComponent[])PsiTreeUtil.getChildrenOfType((PsiElement)body, DartComponent.class);
        DartVarDeclarationList[] variables = (DartVarDeclarationList[])PsiTreeUtil.getChildrenOfType((PsiElement)body, DartVarDeclarationList.class);
        if (namedComponents != null) {
            ContainerUtil.addAll(result, (Object[])namedComponents);
        }
        if (variables == null) {
            ArrayList<DartComponent> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "getNamedSubComponents"));
            }
            return arrayList;
        }
        for (DartVarDeclarationList varDeclarationList : variables) {
            result.add(varDeclarationList.getVarAccessDeclaration());
            result.addAll(varDeclarationList.getVarDeclarationListPartList());
        }
        ArrayList<DartComponent> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "getNamedSubComponents"));
        }
        return arrayList;
    }

    @Nullable
    public static DartClassMembers getBody(@Nullable DartClass dartClass) {
        DartClassBody body = dartClass instanceof DartClassDefinition ? ((DartClassDefinition)dartClass).getClassBody() : null;
        return body == null ? null : body.getClassMembers();
    }

    public static List<DartComponent> filterComponentsByType(List<DartComponent> components, DartComponentType type) {
        return ContainerUtil.filter(components, component -> type == DartComponentType.typeOf((PsiElement)component));
    }

    public static List<DartType> getTypes(@Nullable DartTypeList typeList) {
        if (typeList == null) {
            return Collections.emptyList();
        }
        return typeList.getTypeList();
    }

    @NotNull
    public static DartClassResolveResult resolveClassByType(@Nullable DartType dartType) {
        DartClassResolveResult dartClassResolveResult = DartResolveUtil.resolveClassByType(dartType, DartClassResolveResult.EMPTY);
        if (dartClassResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "resolveClassByType"));
        }
        return dartClassResolveResult;
    }

    private static DartClassResolveResult resolveClassByType(DartType dartType, DartClassResolveResult initializer) {
        if (dartType == null) {
            return DartClassResolveResult.EMPTY;
        }
        PsiElement target = dartType.resolveReference();
        if (target instanceof DartComponentName) {
            PsiElement targetParent = target.getParent();
            if (targetParent == initializer.getDartClass()) {
                return initializer;
            }
            if (targetParent instanceof DartClass) {
                return DartClassResolveResult.create((DartClass)targetParent);
            }
            if (DartComponentType.typeOf(targetParent) == DartComponentType.CONSTRUCTOR) {
                return DartClassResolveResult.create((DartClass)PsiTreeUtil.getParentOfType((PsiElement)target, DartClass.class));
            }
        }
        return DartClassResolveResult.EMPTY;
    }

    @NotNull
    public static DartClassResolveResult getDartClassResolveResult(@Nullable PsiElement element) {
        DartClassResolveResult dartClassResolveResult = DartResolveUtil.getDartClassResolveResult(element, new DartGenericSpecialization());
        if (dartClassResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "getDartClassResolveResult"));
        }
        return dartClassResolveResult;
    }

    @NotNull
    public static DartClassResolveResult getDartClassResolveResult(@Nullable PsiElement element, @NotNull DartGenericSpecialization specialization) {
        DartExpression initExpression;
        DartReference functionBodyExpression;
        if (specialization == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specialization", "com/jetbrains/lang/dart/util/DartResolveUtil", "getDartClassResolveResult"));
        }
        if (element == null) {
            DartClassResolveResult dartClassResolveResult = DartClassResolveResult.create(null);
            if (dartClassResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "getDartClassResolveResult"));
            }
            return dartClassResolveResult;
        }
        PsiElement parentElement = element.getParent();
        if (parentElement instanceof DartEnumConstantDeclaration) {
            DartClassResolveResult dartClassResolveResult = DartResolveUtil.getDartClassResolveResult(parentElement.getParent());
            if (dartClassResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "getDartClassResolveResult"));
            }
            return dartClassResolveResult;
        }
        if (element instanceof DartComponentName) {
            DartClassResolveResult dartClassResolveResult = DartResolveUtil.getDartClassResolveResult(parentElement, specialization);
            if (dartClassResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "getDartClassResolveResult"));
            }
            return dartClassResolveResult;
        }
        if (element instanceof DartClass) {
            DartClass dartClass = (DartClass)element;
            DartClassResolveResult dartClassResolveResult = DartClassResolveResult.create(dartClass, specialization);
            if (dartClassResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "getDartClassResolveResult"));
            }
            return dartClassResolveResult;
        }
        DartClassResolveResult result = DartResolveUtil.tryFindTypeAndResolveClass(element, specialization);
        if (result.getDartClass() != null) {
            DartClassResolveResult dartClassResolveResult = result;
            if (dartClassResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "getDartClassResolveResult"));
            }
            return dartClassResolveResult;
        }
        PsiElement functionBody = PsiTreeUtil.getChildOfType((PsiElement)element, DartFunctionBody.class);
        if (functionBody == null) {
            functionBody = PsiTreeUtil.getChildOfType((PsiElement)element, DartFunctionExpressionBody.class);
        }
        if ((functionBodyExpression = (DartReference)PsiTreeUtil.getChildOfType((PsiElement)functionBody, DartReference.class)) != null) {
            DartClassResolveResult dartClassResolveResult = functionBodyExpression.resolveDartClass();
            if (dartClassResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "getDartClassResolveResult"));
            }
            return dartClassResolveResult;
        }
        if (specialization.containsKey(null, element.getText())) {
            DartClassResolveResult dartClassResolveResult = specialization.get(null, element.getText());
            if (dartClassResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "getDartClassResolveResult"));
            }
            return dartClassResolveResult;
        }
        if (element instanceof DartVarAccessDeclaration && parentElement instanceof DartForInPart) {
            DartForInPart forInPart = (DartForInPart)parentElement;
            DartClassResolveResult dartClassResolveResult = DartResolveUtil.resolveForInPartClass(forInPart);
            if (dartClassResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "getDartClassResolveResult"));
            }
            return dartClassResolveResult;
        }
        if (element instanceof DartForInPart) {
            DartForInPart forInPart = (DartForInPart)element;
            DartClassResolveResult dartClassResolveResult = DartResolveUtil.resolveForInPartClass(forInPart);
            if (dartClassResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "getDartClassResolveResult"));
            }
            return dartClassResolveResult;
        }
        if (element instanceof DartSimpleFormalParameter && parentElement instanceof DartNormalFormalParameter && parentElement.getParent() instanceof DartFormalParameterList && parentElement.getParent().getParent() instanceof DartFunctionExpression && parentElement.getParent().getParent().getParent() instanceof DartArgumentList) {
            PsiElement argument;
            int parameterIndex = DartResolveUtil.getParameterIndex(parentElement, (DartFormalParameterList)parentElement.getParent());
            int argumentIndex = DartResolveUtil.getArgumentIndex(parentElement.getParent().getParent());
            DartCallExpression callExpression = (DartCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, DartCallExpression.class);
            DartReference callReference = callExpression == null ? null : (DartReference)callExpression.getExpression();
            PsiElement target = callReference == null ? null : callReference.resolve();
            PsiElement psiElement = argument = target == null ? null : DartResolveUtil.findParameter(target.getParent(), argumentIndex);
            if (argument instanceof DartNormalFormalParameter) {
                DartType dartType = DartResolveUtil.findParameterType((PsiElement)((DartNormalFormalParameter)argument).getFunctionFormalParameter(), parameterIndex);
                DartClassResolveResult callClassResolveResult = DartResolveUtil.getLeftClassResolveResult(callReference);
                DartClassResolveResult dartClassResolveResult = DartResolveUtil.getDartClassResolveResult((PsiElement)dartType, callClassResolveResult.getSpecialization());
                if (dartClassResolveResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "getDartClassResolveResult"));
                }
                return dartClassResolveResult;
            }
            DartClassResolveResult dartClassResolveResult = DartClassResolveResult.EMPTY;
            if (dartClassResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "getDartClassResolveResult"));
            }
            return dartClassResolveResult;
        }
        DartVarInit varInit = (DartVarInit)PsiTreeUtil.getChildOfType((PsiElement)(element instanceof DartVarDeclarationListPart ? element : parentElement), DartVarInit.class);
        DartExpression dartExpression = initExpression = varInit == null ? null : varInit.getExpression();
        if (initExpression instanceof DartReference) {
            result = ((DartReference)initExpression).resolveDartClass();
            result.specialize((PsiElement)initExpression);
            DartClassResolveResult dartClassResolveResult = result;
            if (dartClassResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "getDartClassResolveResult"));
            }
            return dartClassResolveResult;
        }
        DartClassResolveResult dartClassResolveResult = DartResolveUtil.getDartClassResolveResult((PsiElement)initExpression);
        if (dartClassResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "getDartClassResolveResult"));
        }
        return dartClassResolveResult;
    }

    private static DartClassResolveResult getLeftClassResolveResult(DartReference reference) {
        DartReference[] references = (DartReference[])PsiTreeUtil.getChildrenOfType((PsiElement)reference, DartReference.class);
        if (references != null && references.length == 2) {
            return references[0].resolveDartClass();
        }
        return DartClassResolveResult.create((DartClass)PsiTreeUtil.getChildOfType((PsiElement)reference, DartClass.class));
    }

    @Nullable
    public static DartComponent findConstructorDeclaration(DartNewExpression newExpression) {
        DartType type = newExpression.getType();
        DartReferenceExpression psiElement = type != null ? type.getReferenceExpression() : null;
        PsiElement target = psiElement != null ? ((DartReference)psiElement).resolve() : null;
        return target != null ? (DartComponent)target.getParent() : null;
    }

    @Nullable
    private static PsiElement findParameter(@Nullable PsiElement element, int index) {
        DartFormalParameterList parameterList = (DartFormalParameterList)PsiTreeUtil.getChildOfType((PsiElement)element, DartFormalParameterList.class);
        if (parameterList == null) {
            return null;
        }
        int normalParameterSize = parameterList.getNormalFormalParameterList().size();
        if (index < normalParameterSize) {
            return (PsiElement)parameterList.getNormalFormalParameterList().get(index);
        }
        DartOptionalFormalParameters optionalFormalParameters = parameterList.getOptionalFormalParameters();
        return optionalFormalParameters == null ? null : (PsiElement)optionalFormalParameters.getDefaultFormalNamedParameterList().get(index - normalParameterSize);
    }

    @Nullable
    private static DartType findParameterType(@Nullable PsiElement element, int index) {
        PsiElement target = DartResolveUtil.findParameter(element, index);
        return DartResolveUtil.findType(target);
    }

    private static int getParameterIndex(@NotNull PsiElement element, @NotNull DartFormalParameterList parameterList) {
        int namedIndex;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/util/DartResolveUtil", "getParameterIndex"));
        }
        if (parameterList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterList", "com/jetbrains/lang/dart/util/DartResolveUtil", "getParameterIndex"));
        }
        int normalIndex = parameterList.getNormalFormalParameterList().indexOf(element);
        DartOptionalFormalParameters formalParameters = parameterList.getOptionalFormalParameters();
        int n = namedIndex = formalParameters == null ? -1 : formalParameters.getDefaultFormalNamedParameterList().indexOf(element);
        return normalIndex >= 0 ? normalIndex : (namedIndex >= 0 ? namedIndex + parameterList.getNormalFormalParameterList().size() : -1);
    }

    private static DartClassResolveResult resolveForInPartClass(DartForInPart forInPart) {
        DartExpression expression = forInPart.getExpression();
        DartReference dartReference = expression instanceof DartReference ? (DartReference)expression : null;
        DartClassResolveResult classResolveResult = dartReference == null ? DartClassResolveResult.EMPTY : dartReference.resolveDartClass();
        DartClass dartClass = classResolveResult.getDartClass();
        DartClassResolveResult iteratorResult = dartClass == null ? DartClassResolveResult.EMPTY : DartResolveUtil.getDartClassResolveResult((PsiElement)dartClass.findMemberByName("iterator"), classResolveResult.getSpecialization());
        DartClassResolveResult finalResult = iteratorResult.getSpecialization().get(null, "E");
        return finalResult == null ? DartClassResolveResult.EMPTY : finalResult;
    }

    public static int getArgumentIndex(PsiElement place) {
        int parameterIndex = -1;
        DartArgumentList argumentList = (DartArgumentList)PsiTreeUtil.getParentOfType((PsiElement)place, DartArgumentList.class, (boolean)false);
        if (place == argumentList) {
            assert (argumentList != null);
            DartFunctionDescription functionDescription = DartFunctionDescription.tryGetDescription((DartCallExpression)argumentList.getParent());
            parameterIndex = functionDescription == null ? -1 : functionDescription.getParameters().length - 1;
        } else if (argumentList != null) {
            for (DartExpression expression : argumentList.getExpressionList()) {
                ++parameterIndex;
                if (expression.getTextRange().getEndOffset() < place.getTextRange().getStartOffset()) continue;
                break;
            }
        } else if (UsefulPsiTreeUtil.getPrevSiblingSkipWhiteSpacesAndComments(place, true) instanceof DartArgumentList) {
            DartArgumentList prevSibling = (DartArgumentList)UsefulPsiTreeUtil.getPrevSiblingSkipWhiteSpacesAndComments(place, true);
            assert (prevSibling != null);
            parameterIndex = prevSibling.getExpressionList().size() + prevSibling.getNamedArgumentList().size();
        } else if (DartParameterInfoHandler.findElementForParameterInfo(place) != null) {
            parameterIndex = 0;
        }
        return parameterIndex;
    }

    @NotNull
    private static DartClassResolveResult tryFindTypeAndResolveClass(@Nullable PsiElement element, DartGenericSpecialization specialization) {
        DartClass dartClass;
        PsiElement parent;
        DartType type = (DartType)PsiTreeUtil.getChildOfType((PsiElement)element, DartType.class);
        if (type == null && element instanceof DartType) {
            type = (DartType)element;
        } else if (type == null) {
            DartReturnType returnType = (DartReturnType)PsiTreeUtil.getChildOfType((PsiElement)element, DartReturnType.class);
            DartType dartType = type = returnType == null ? null : returnType.getType();
        }
        if (type == null && element instanceof DartVarDeclarationListPart && (parent = element.getParent()) instanceof DartVarDeclarationList) {
            type = ((DartVarDeclarationList)parent).getVarAccessDeclaration().getType();
        }
        DartClass dartClass2 = dartClass = type == null ? null : DartResolveUtil.resolveClassByType(type).getDartClass();
        if (dartClass == null && type != null && specialization.containsKey(element, type.getText())) {
            DartClassResolveResult dartClassResolveResult = specialization.get(element, type.getText());
            if (dartClassResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "tryFindTypeAndResolveClass"));
            }
            return dartClassResolveResult;
        }
        DartClassResolveResult result = DartResolveUtil.getDartClassResolveResult((PsiElement)dartClass, specialization.getInnerSpecialization(element));
        if (result.getDartClass() != null) {
            result.specializeByParameters(type == null ? null : type.getTypeArguments());
            DartClassResolveResult dartClassResolveResult = result;
            if (dartClassResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "tryFindTypeAndResolveClass"));
            }
            return dartClassResolveResult;
        }
        DartClassResolveResult dartClassResolveResult = DartClassResolveResult.EMPTY;
        if (dartClassResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "tryFindTypeAndResolveClass"));
        }
        return dartClassResolveResult;
    }

    @NotNull
    public static String getOperatorString(@Nullable PsiElement element) {
        if (element == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "getOperatorString"));
            }
            return "";
        }
        final StringBuilder result = new StringBuilder();
        element.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof LeafPsiElement && DartTokenTypesSets.OPERATORS.contains(((LeafPsiElement)element).getElementType())) {
                    result.append(element.getText());
                }
                super.visitElement(element);
            }
        });
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "getOperatorString"));
        }
        return string;
    }

    @Nullable
    public static DartComponent findReferenceAndComponentTarget(@Nullable PsiElement element) {
        PsiElement targetParent;
        DartReference reference = (DartReference)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{DartReference.class});
        PsiElement target = reference == null ? null : reference.resolve();
        PsiElement psiElement = targetParent = target != null ? target.getParent() : null;
        if (targetParent instanceof DartComponent) {
            return (DartComponent)targetParent;
        }
        return null;
    }

    public static boolean aloneOrFirstInChain(DartReference reference) {
        return PsiTreeUtil.getChildrenOfType((PsiElement)reference, DartReference.class) == null && DartResolveUtil.getLeftReference((PsiElement)reference) == null && DartResolveUtil.getLeftReference(reference.getParent()) == null;
    }

    @NotNull
    public static ResolveResult[] toCandidateInfoArray(@Nullable List<? extends PsiElement> elements) {
        if (elements == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "toCandidateInfoArray"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        elements = ContainerUtil.filter(elements, element -> element != null);
        ResolveResult[] result = new ResolveResult[elements.size()];
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            result[i] = new PsiElementResolveResult((PsiElement)elements.get(i));
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartResolveUtil", "toCandidateInfoArray"));
        }
        return result;
    }

    public static List<DartType> getImplementsAndMixinsList(DartClass dartClass) {
        return ContainerUtil.concat(dartClass.getImplementsList(), dartClass.getMixinsList());
    }
}

