/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairConsumer;
import com.jetbrains.lang.dart.ide.index.DartLibraryIndex;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.util.DartUrlResolverImpl;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DartUrlResolver {
    public static final String DART_SCHEME = "dart";
    public static final String DART_PREFIX = "dart:";
    public static final String PACKAGE_SCHEME = "package";
    public static final String PACKAGE_PREFIX = "package:";
    public static final String FILE_SCHEME = "file";
    public static final String FILE_PREFIX = "file:";
    public static final String TEMP_SCHEME = "temp";
    public static final String TEMP_PREFIX = "temp:";
    public static final String PACKAGES_FOLDER_NAME = "packages";
    public static final String DART_CORE_URI = "dart:core";

    @NotNull
    public static DartUrlResolver getInstance(@NotNull Project project, @NotNull VirtualFile contextFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/util/DartUrlResolver", "getInstance"));
        }
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFile", "com/jetbrains/lang/dart/util/DartUrlResolver", "getInstance"));
        }
        DartUrlResolverImpl dartUrlResolverImpl = new DartUrlResolverImpl(project, contextFile);
        if (dartUrlResolverImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartUrlResolver", "getInstance"));
        }
        return dartUrlResolverImpl;
    }

    @Nullable
    public abstract VirtualFile getPubspecYamlFile();

    public abstract void processLivePackages(@NotNull PairConsumer<String, VirtualFile> var1);

    public abstract Collection<String> getLivePackageNames();

    @Nullable
    public abstract VirtualFile getPackageDirIfNotInOldStylePackagesFolder(@NotNull String var1, @Nullable String var2);

    @Nullable
    public abstract VirtualFile findFileByDartUrl(@NotNull String var1);

    @Nullable
    public static VirtualFile findFileInDartSdkLibFolder(@NotNull Project project, @Nullable DartSdk dartSdk, @Nullable String dartUri) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/util/DartUrlResolver", "findFileInDartSdkLibFolder"));
        }
        if (dartSdk == null || dartUri == null || !dartUri.startsWith(DART_PREFIX)) {
            return null;
        }
        int firstSlashIndex = dartUri.indexOf(47);
        if (firstSlashIndex < 0) {
            return DartLibraryIndex.getSdkLibByUri(project, dartUri);
        }
        String mainLibUri = dartUri.substring(0, firstSlashIndex);
        VirtualFile mainLibFile = DartLibraryIndex.getSdkLibByUri(project, mainLibUri);
        if (mainLibFile != null) {
            String partRelPath = dartUri.substring(firstSlashIndex + 1);
            VirtualFile partFile = mainLibFile.getParent().findFileByRelativePath(partRelPath);
            if (partFile != null) {
                return partFile;
            }
        }
        String sdkLibRelPath = dartUri.substring(DART_PREFIX.length());
        String path = dartSdk.getHomePath() + "/lib/" + sdkLibRelPath;
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    @NotNull
    public abstract String getDartUrlForFile(@NotNull VirtualFile var1);

    public boolean mayNeedDynamicUpdate() {
        return true;
    }
}

