/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.util.PairConsumer;
import com.jetbrains.lang.dart.ide.index.DartLibraryIndex;
import com.jetbrains.lang.dart.sdk.DartPackagesLibraryProperties;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import com.jetbrains.lang.dart.util.DotPackagesFileUtil;
import com.jetbrains.lang.dart.util.PubspecYamlUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartUrlResolverImpl
extends DartUrlResolver {
    @NotNull
    private final Project myProject;
    @Nullable
    private final DartSdk myDartSdk;
    @Nullable
    private final VirtualFile myPubspecYamlFile;
    @NotNull
    private final Map<String, VirtualFile> myLivePackageNameToDirMap;
    @NotNull
    private final Map<String, List<String>> myPackagesMapFromLib;

    public DartUrlResolverImpl(@NotNull Project project, @NotNull VirtualFile contextFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/util/DartUrlResolverImpl", "<init>"));
        }
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFile", "com/jetbrains/lang/dart/util/DartUrlResolverImpl", "<init>"));
        }
        this.myLivePackageNameToDirMap = new THashMap();
        this.myPackagesMapFromLib = new THashMap();
        this.myProject = project;
        this.myDartSdk = DartSdk.getDartSdk(project);
        this.myPubspecYamlFile = PubspecYamlUtil.findPubspecYamlFile(this.myProject, contextFile);
        this.initLivePackageNameToDirMap();
        if (this.myPubspecYamlFile == null) {
            this.initPackagesMapFromLib(contextFile);
        }
    }

    @Override
    @Nullable
    public VirtualFile getPubspecYamlFile() {
        return this.myPubspecYamlFile;
    }

    @Override
    public void processLivePackages(@NotNull PairConsumer<String, VirtualFile> packageNameAndDirConsumer) {
        if (packageNameAndDirConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageNameAndDirConsumer", "com/jetbrains/lang/dart/util/DartUrlResolverImpl", "processLivePackages"));
        }
        for (Map.Entry<String, VirtualFile> entry : this.myLivePackageNameToDirMap.entrySet()) {
            packageNameAndDirConsumer.consume((Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    @Override
    public Collection<String> getLivePackageNames() {
        return this.myLivePackageNameToDirMap.keySet();
    }

    @Override
    @Nullable
    public VirtualFile getPackageDirIfNotInOldStylePackagesFolder(@NotNull String packageName, @Nullable String pathRelToPackageDir) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/lang/dart/util/DartUrlResolverImpl", "getPackageDirIfNotInOldStylePackagesFolder"));
        }
        VirtualFile dir = this.myLivePackageNameToDirMap.get(packageName);
        if (dir != null) {
            return dir;
        }
        List<String> dirPaths = this.myPackagesMapFromLib.get(packageName);
        if (dirPaths != null) {
            VirtualFile notNullPackageDir = null;
            for (String dirPath : dirPaths) {
                VirtualFile packageDir;
                VirtualFile virtualFile = packageDir = ApplicationManager.getApplication().isUnitTestMode() ? TempFileSystem.getInstance().findFileByPath(dirPath) : LocalFileSystem.getInstance().findFileByPath(dirPath);
                if (notNullPackageDir == null && packageDir != null) {
                    notNullPackageDir = packageDir;
                }
                if (packageDir == null || !StringUtil.isEmpty((String)pathRelToPackageDir) && packageDir.findFileByRelativePath(pathRelToPackageDir) == null) continue;
                return packageDir;
            }
            return notNullPackageDir;
        }
        return null;
    }

    @Override
    @Nullable
    public VirtualFile findFileByDartUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/lang/dart/util/DartUrlResolverImpl", "findFileByDartUrl"));
        }
        if (url.startsWith("dart:")) {
            return DartUrlResolverImpl.findFileInDartSdkLibFolder(this.myProject, this.myDartSdk, url);
        }
        if (url.startsWith("package:")) {
            VirtualFile packageDir;
            String packageRelPath = url.substring("package:".length());
            int slashIndex = packageRelPath.indexOf(47);
            String packageName = slashIndex > 0 ? packageRelPath.substring(0, slashIndex) : packageRelPath;
            String pathRelToPackageDir = slashIndex > 0 ? packageRelPath.substring(slashIndex + 1) : "";
            VirtualFile virtualFile = packageDir = StringUtil.isEmpty((String)packageName) ? null : this.myLivePackageNameToDirMap.get(packageName);
            if (packageDir != null) {
                return packageDir.findFileByRelativePath(pathRelToPackageDir);
            }
            List<String> packageDirs = this.myPackagesMapFromLib.get(packageName);
            if (packageDirs != null) {
                for (String packageDirPath : packageDirs) {
                    VirtualFile file = LocalFileSystem.getInstance().findFileByPath(packageDirPath + "/" + pathRelToPackageDir);
                    if (file == null) continue;
                    return file;
                }
            }
        }
        if (url.startsWith("file:")) {
            String path = StringUtil.trimLeading((String)url.substring("file:".length()), (char)'/');
            return LocalFileSystem.getInstance().findFileByPath(SystemInfo.isWindows ? path : "/" + path);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && url.startsWith("temp:")) {
            return TempFileSystem.getInstance().findFileByPath(url.substring("temp:".length()));
        }
        return null;
    }

    @Override
    @NotNull
    public String getDartUrlForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/util/DartUrlResolverImpl", "getDartUrlForFile"));
        }
        String result = null;
        if (this.myDartSdk != null) {
            result = DartUrlResolverImpl.getUrlIfFileFromSdkLib(this.myProject, file, this.myDartSdk);
        }
        if (result != null) {
            String string = result;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartUrlResolverImpl", "getDartUrlForFile"));
            }
            return string;
        }
        result = DartUrlResolverImpl.getUrlIfFileFromLivePackage(file, this.myLivePackageNameToDirMap);
        if (result != null) {
            String string = result;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartUrlResolverImpl", "getDartUrlForFile"));
            }
            return string;
        }
        result = DartUrlResolverImpl.getUrlIfFileFromDartPackagesLib(file, this.myPackagesMapFromLib);
        if (result != null) {
            String string = result;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartUrlResolverImpl", "getDartUrlForFile"));
            }
            return string;
        }
        String string = new File(file.getPath()).toURI().toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/util/DartUrlResolverImpl", "getDartUrlForFile"));
        }
        return string;
    }

    @Nullable
    private static String getUrlIfFileFromSdkLib(@NotNull Project project, @NotNull VirtualFile file, @NotNull DartSdk sdk) {
        String sdkLibUri;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/util/DartUrlResolverImpl", "getUrlIfFileFromSdkLib"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/util/DartUrlResolverImpl", "getUrlIfFileFromSdkLib"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/lang/dart/util/DartUrlResolverImpl", "getUrlIfFileFromSdkLib"));
        }
        VirtualFile sdkLibFolder = LocalFileSystem.getInstance().findFileByPath(sdk.getHomePath() + "/lib");
        String relativeToSdkLibFolder = sdkLibFolder == null ? null : VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)sdkLibFolder, (char)'/');
        String string = sdkLibUri = relativeToSdkLibFolder == null ? null : DartLibraryIndex.getSdkLibUriByRelativePath(project, relativeToSdkLibFolder);
        return sdkLibUri != null ? sdkLibUri : (relativeToSdkLibFolder != null ? "dart:" + relativeToSdkLibFolder : null);
    }

    @Nullable
    private static String getUrlIfFileFromLivePackage(@NotNull VirtualFile file, @NotNull Map<String, VirtualFile> livePackageNameToDirMap) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/util/DartUrlResolverImpl", "getUrlIfFileFromLivePackage"));
        }
        if (livePackageNameToDirMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "livePackageNameToDirMap", "com/jetbrains/lang/dart/util/DartUrlResolverImpl", "getUrlIfFileFromLivePackage"));
        }
        for (Map.Entry<String, VirtualFile> entry : livePackageNameToDirMap.entrySet()) {
            String packageName = entry.getKey();
            VirtualFile packageDir = entry.getValue();
            String relPath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)packageDir, (char)'/');
            if (relPath == null) continue;
            return "package:" + packageName + "/" + relPath;
        }
        return null;
    }

    @Nullable
    private static String getUrlIfFileFromDartPackagesLib(@NotNull VirtualFile file, @NotNull Map<String, List<String>> pubListPackageDirsMap) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/util/DartUrlResolverImpl", "getUrlIfFileFromDartPackagesLib"));
        }
        if (pubListPackageDirsMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pubListPackageDirsMap", "com/jetbrains/lang/dart/util/DartUrlResolverImpl", "getUrlIfFileFromDartPackagesLib"));
        }
        for (Map.Entry<String, List<String>> mapEntry : pubListPackageDirsMap.entrySet()) {
            for (String dirPath : mapEntry.getValue()) {
                if (!file.getPath().startsWith(dirPath + "/")) continue;
                String packageName = mapEntry.getKey();
                return "package:" + packageName + file.getPath().substring(dirPath.length());
            }
        }
        return null;
    }

    private void initLivePackageNameToDirMap() {
        VirtualFile baseDir;
        VirtualFile virtualFile = baseDir = this.myPubspecYamlFile == null ? null : this.myPubspecYamlFile.getParent();
        if (this.myPubspecYamlFile == null || baseDir == null) {
            return;
        }
        VirtualFile dotPackagesFile = baseDir.findChild(".packages");
        if (dotPackagesFile != null && !dotPackagesFile.isDirectory()) {
            Map<String, String> packagesMap = DotPackagesFileUtil.getPackagesMap(dotPackagesFile);
            if (packagesMap != null) {
                for (Map.Entry<String, String> entry : packagesMap.entrySet()) {
                    String packageName2 = entry.getKey();
                    String packagePath = entry.getValue();
                    VirtualFile packageDir2 = this.myPubspecYamlFile.getFileSystem().findFileByPath(packagePath);
                    if (packageDir2 == null) continue;
                    this.myLivePackageNameToDirMap.put(packageName2, packageDir2);
                }
            }
        } else {
            String name = PubspecYamlUtil.getDartProjectName(this.myPubspecYamlFile);
            VirtualFile libFolder = baseDir.findChild("lib");
            if (name != null && libFolder != null && libFolder.isDirectory()) {
                this.myLivePackageNameToDirMap.put(name, libFolder);
            }
            PubspecYamlUtil.processInProjectPathPackagesRecursively(this.myProject, this.myPubspecYamlFile, (PairConsumer<String, VirtualFile>)((PairConsumer)(packageName, packageDir) -> this.myLivePackageNameToDirMap.put((String)packageName, (VirtualFile)packageDir)));
        }
    }

    private void initPackagesMapFromLib(@NotNull VirtualFile contextFile) {
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFile", "com/jetbrains/lang/dart/util/DartUrlResolverImpl", "initPackagesMapFromLib"));
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)contextFile, (Project)this.myProject);
        List orderEntries = module != null ? Arrays.asList(ModuleRootManager.getInstance((Module)module).getOrderEntries()) : ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getOrderEntriesForFile(contextFile);
        for (OrderEntry orderEntry : orderEntries) {
            LibraryEx library;
            LibraryProperties properties;
            if (!(orderEntry instanceof LibraryOrderEntry) || !"project".equals(((LibraryOrderEntry)orderEntry).getLibraryLevel()) || !"Dart Packages".equals(((LibraryOrderEntry)orderEntry).getLibraryName()) || !((properties = (library = (LibraryEx)((LibraryOrderEntry)orderEntry).getLibrary()) == null ? null : library.getProperties()) instanceof DartPackagesLibraryProperties)) continue;
            for (Map.Entry<String, List<String>> entry : ((DartPackagesLibraryProperties)properties).getPackageNameToDirsMap().entrySet()) {
                if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
                this.myPackagesMapFromLib.put(entry.getKey(), entry.getValue());
            }
            return;
        }
    }
}

