/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class AddContentOverlay {
    public static final AddContentOverlay[] EMPTY_ARRAY = new AddContentOverlay[0];
    public static final List<AddContentOverlay> EMPTY_LIST = Lists.newArrayList();
    private final String type;
    private final String content;

    public AddContentOverlay(String content) {
        this.type = "add";
        this.content = content;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AddContentOverlay) {
            AddContentOverlay other = (AddContentOverlay)obj;
            return ObjectUtilities.equals(other.type, this.type) && ObjectUtilities.equals(other.content, this.content);
        }
        return false;
    }

    public static AddContentOverlay fromJson(JsonObject jsonObject) {
        String type = jsonObject.get("type").getAsString();
        String content = jsonObject.get("content").getAsString();
        return new AddContentOverlay(content);
    }

    public static List<AddContentOverlay> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<AddContentOverlay> list = new ArrayList<AddContentOverlay>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(AddContentOverlay.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public String getContent() {
        return this.content;
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.type);
        builder.append((Object)this.content);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", this.type);
        jsonObject.addProperty("content", this.content);
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("type=");
        builder.append(this.type + ", ");
        builder.append("content=");
        builder.append(this.content);
        builder.append("]");
        return builder.toString();
    }
}

