/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.Location;

public class AnalysisError {
    public static final AnalysisError[] EMPTY_ARRAY = new AnalysisError[0];
    public static final List<AnalysisError> EMPTY_LIST = Lists.newArrayList();
    private final String severity;
    private final String type;
    private final Location location;
    private final String message;
    private final String correction;
    private final String code;
    private final Boolean hasFix;

    public AnalysisError(String severity, String type, Location location, String message, String correction, String code, Boolean hasFix) {
        this.severity = severity;
        this.type = type;
        this.location = location;
        this.message = message;
        this.correction = correction;
        this.code = code;
        this.hasFix = hasFix;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AnalysisError) {
            AnalysisError other = (AnalysisError)obj;
            return ObjectUtilities.equals(other.severity, this.severity) && ObjectUtilities.equals(other.type, this.type) && ObjectUtilities.equals(other.location, this.location) && ObjectUtilities.equals(other.message, this.message) && ObjectUtilities.equals(other.correction, this.correction) && ObjectUtilities.equals(other.code, this.code) && ObjectUtilities.equals(other.hasFix, this.hasFix);
        }
        return false;
    }

    public static AnalysisError fromJson(JsonObject jsonObject) {
        String severity = jsonObject.get("severity").getAsString();
        String type = jsonObject.get("type").getAsString();
        Location location = Location.fromJson(jsonObject.get("location").getAsJsonObject());
        String message = jsonObject.get("message").getAsString();
        String correction = jsonObject.get("correction") == null ? null : jsonObject.get("correction").getAsString();
        String code = jsonObject.get("code") == null ? null : jsonObject.get("code").getAsString();
        Boolean hasFix = jsonObject.get("hasFix") == null ? null : Boolean.valueOf(jsonObject.get("hasFix").getAsBoolean());
        return new AnalysisError(severity, type, location, message, correction, code, hasFix);
    }

    public static List<AnalysisError> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<AnalysisError> list = new ArrayList<AnalysisError>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(AnalysisError.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public String getCode() {
        return this.code;
    }

    public String getCorrection() {
        return this.correction;
    }

    public Boolean getHasFix() {
        return this.hasFix;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.severity);
        builder.append((Object)this.type);
        builder.append((Object)this.location);
        builder.append((Object)this.message);
        builder.append((Object)this.correction);
        builder.append((Object)this.code);
        builder.append((Object)this.hasFix);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("severity", this.severity);
        jsonObject.addProperty("type", this.type);
        jsonObject.add("location", (JsonElement)this.location.toJson());
        jsonObject.addProperty("message", this.message);
        if (this.correction != null) {
            jsonObject.addProperty("correction", this.correction);
        }
        jsonObject.addProperty("code", this.code);
        if (this.hasFix != null) {
            jsonObject.addProperty("hasFix", this.hasFix);
        }
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("severity=");
        builder.append(this.severity + ", ");
        builder.append("type=");
        builder.append(this.type + ", ");
        builder.append("location=");
        builder.append(this.location + ", ");
        builder.append("message=");
        builder.append(this.message + ", ");
        builder.append("correction=");
        builder.append(this.correction + ", ");
        builder.append("code=");
        builder.append(this.code + ", ");
        builder.append("hasFix=");
        builder.append(this.hasFix);
        builder.append("]");
        return builder.toString();
    }
}

