/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.AnalysisError;
import org.dartlang.analysis.server.protocol.SourceChange;

public class AnalysisErrorFixes {
    public static final AnalysisErrorFixes[] EMPTY_ARRAY = new AnalysisErrorFixes[0];
    public static final List<AnalysisErrorFixes> EMPTY_LIST = Lists.newArrayList();
    private final AnalysisError error;
    private final List<SourceChange> fixes;

    public AnalysisErrorFixes(AnalysisError error, List<SourceChange> fixes) {
        this.error = error;
        this.fixes = fixes;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AnalysisErrorFixes) {
            AnalysisErrorFixes other = (AnalysisErrorFixes)obj;
            return ObjectUtilities.equals(other.error, this.error) && ObjectUtilities.equals(other.fixes, this.fixes);
        }
        return false;
    }

    public static AnalysisErrorFixes fromJson(JsonObject jsonObject) {
        AnalysisError error = AnalysisError.fromJson(jsonObject.get("error").getAsJsonObject());
        List<SourceChange> fixes = SourceChange.fromJsonArray(jsonObject.get("fixes").getAsJsonArray());
        return new AnalysisErrorFixes(error, fixes);
    }

    public static List<AnalysisErrorFixes> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<AnalysisErrorFixes> list = new ArrayList<AnalysisErrorFixes>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(AnalysisErrorFixes.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public AnalysisError getError() {
        return this.error;
    }

    public List<SourceChange> getFixes() {
        return this.fixes;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.error);
        builder.append(this.fixes);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("error", (JsonElement)this.error.toJson());
        JsonArray jsonArrayFixes = new JsonArray();
        for (SourceChange elt : this.fixes) {
            jsonArrayFixes.add((JsonElement)elt.toJson());
        }
        jsonObject.add("fixes", (JsonElement)jsonArrayFixes);
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("error=");
        builder.append(this.error + ", ");
        builder.append("fixes=");
        builder.append(StringUtils.join(this.fixes, (String)", "));
        builder.append("]");
        return builder.toString();
    }
}

