/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class AnalysisStatus {
    public static final AnalysisStatus[] EMPTY_ARRAY = new AnalysisStatus[0];
    public static final List<AnalysisStatus> EMPTY_LIST = Lists.newArrayList();
    private final boolean isAnalyzing;
    private final String analysisTarget;

    public AnalysisStatus(boolean isAnalyzing, String analysisTarget) {
        this.isAnalyzing = isAnalyzing;
        this.analysisTarget = analysisTarget;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AnalysisStatus) {
            AnalysisStatus other = (AnalysisStatus)obj;
            return other.isAnalyzing == this.isAnalyzing && ObjectUtilities.equals(other.analysisTarget, this.analysisTarget);
        }
        return false;
    }

    public static AnalysisStatus fromJson(JsonObject jsonObject) {
        boolean isAnalyzing = jsonObject.get("isAnalyzing").getAsBoolean();
        String analysisTarget = jsonObject.get("analysisTarget") == null ? null : jsonObject.get("analysisTarget").getAsString();
        return new AnalysisStatus(isAnalyzing, analysisTarget);
    }

    public static List<AnalysisStatus> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<AnalysisStatus> list = new ArrayList<AnalysisStatus>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(AnalysisStatus.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public String getAnalysisTarget() {
        return this.analysisTarget;
    }

    public boolean isAnalyzing() {
        return this.isAnalyzing;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.isAnalyzing);
        builder.append((Object)this.analysisTarget);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("isAnalyzing", Boolean.valueOf(this.isAnalyzing));
        if (this.analysisTarget != null) {
            jsonObject.addProperty("analysisTarget", this.analysisTarget);
        }
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("isAnalyzing=");
        builder.append(this.isAnalyzing + ", ");
        builder.append("analysisTarget=");
        builder.append(this.analysisTarget);
        builder.append("]");
        return builder.toString();
    }
}

