/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.SourceEdit;

public class ChangeContentOverlay {
    public static final ChangeContentOverlay[] EMPTY_ARRAY = new ChangeContentOverlay[0];
    public static final List<ChangeContentOverlay> EMPTY_LIST = Lists.newArrayList();
    private final String type;
    private final List<SourceEdit> edits;

    public ChangeContentOverlay(List<SourceEdit> edits) {
        this.type = "change";
        this.edits = edits;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChangeContentOverlay) {
            ChangeContentOverlay other = (ChangeContentOverlay)obj;
            return ObjectUtilities.equals(other.type, this.type) && ObjectUtilities.equals(other.edits, this.edits);
        }
        return false;
    }

    public static ChangeContentOverlay fromJson(JsonObject jsonObject) {
        String type = jsonObject.get("type").getAsString();
        List<SourceEdit> edits = SourceEdit.fromJsonArray(jsonObject.get("edits").getAsJsonArray());
        return new ChangeContentOverlay(edits);
    }

    public static List<ChangeContentOverlay> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<ChangeContentOverlay> list = new ArrayList<ChangeContentOverlay>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(ChangeContentOverlay.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public List<SourceEdit> getEdits() {
        return this.edits;
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.type);
        builder.append(this.edits);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", this.type);
        JsonArray jsonArrayEdits = new JsonArray();
        for (SourceEdit elt : this.edits) {
            jsonArrayEdits.add((JsonElement)elt.toJson());
        }
        jsonObject.add("edits", (JsonElement)jsonArrayEdits);
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("type=");
        builder.append(this.type + ", ");
        builder.append("edits=");
        builder.append(StringUtils.join(this.edits, (String)", "));
        builder.append("]");
        return builder.toString();
    }
}

