/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.JsonUtilities;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ContextData {
    public static final ContextData[] EMPTY_ARRAY = new ContextData[0];
    public static final List<ContextData> EMPTY_LIST = Lists.newArrayList();
    private final String name;
    private final int explicitFileCount;
    private final int implicitFileCount;
    private final int workItemQueueLength;
    private final List<String> cacheEntryExceptions;

    public ContextData(String name, int explicitFileCount, int implicitFileCount, int workItemQueueLength, List<String> cacheEntryExceptions) {
        this.name = name;
        this.explicitFileCount = explicitFileCount;
        this.implicitFileCount = implicitFileCount;
        this.workItemQueueLength = workItemQueueLength;
        this.cacheEntryExceptions = cacheEntryExceptions;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ContextData) {
            ContextData other = (ContextData)obj;
            return ObjectUtilities.equals(other.name, this.name) && other.explicitFileCount == this.explicitFileCount && other.implicitFileCount == this.implicitFileCount && other.workItemQueueLength == this.workItemQueueLength && ObjectUtilities.equals(other.cacheEntryExceptions, this.cacheEntryExceptions);
        }
        return false;
    }

    public static ContextData fromJson(JsonObject jsonObject) {
        String name = jsonObject.get("name").getAsString();
        int explicitFileCount = jsonObject.get("explicitFileCount").getAsInt();
        int implicitFileCount = jsonObject.get("implicitFileCount").getAsInt();
        int workItemQueueLength = jsonObject.get("workItemQueueLength").getAsInt();
        List<String> cacheEntryExceptions = JsonUtilities.decodeStringList(jsonObject.get("cacheEntryExceptions").getAsJsonArray());
        return new ContextData(name, explicitFileCount, implicitFileCount, workItemQueueLength, cacheEntryExceptions);
    }

    public static List<ContextData> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<ContextData> list = new ArrayList<ContextData>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(ContextData.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public List<String> getCacheEntryExceptions() {
        return this.cacheEntryExceptions;
    }

    public int getExplicitFileCount() {
        return this.explicitFileCount;
    }

    public int getImplicitFileCount() {
        return this.implicitFileCount;
    }

    public String getName() {
        return this.name;
    }

    public int getWorkItemQueueLength() {
        return this.workItemQueueLength;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.name);
        builder.append(this.explicitFileCount);
        builder.append(this.implicitFileCount);
        builder.append(this.workItemQueueLength);
        builder.append(this.cacheEntryExceptions);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", this.name);
        jsonObject.addProperty("explicitFileCount", (Number)this.explicitFileCount);
        jsonObject.addProperty("implicitFileCount", (Number)this.implicitFileCount);
        jsonObject.addProperty("workItemQueueLength", (Number)this.workItemQueueLength);
        JsonArray jsonArrayCacheEntryExceptions = new JsonArray();
        for (String elt : this.cacheEntryExceptions) {
            jsonArrayCacheEntryExceptions.add((JsonElement)new JsonPrimitive(elt));
        }
        jsonObject.add("cacheEntryExceptions", (JsonElement)jsonArrayCacheEntryExceptions);
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("name=");
        builder.append(this.name + ", ");
        builder.append("explicitFileCount=");
        builder.append(this.explicitFileCount + ", ");
        builder.append("implicitFileCount=");
        builder.append(this.implicitFileCount + ", ");
        builder.append("workItemQueueLength=");
        builder.append(this.workItemQueueLength + ", ");
        builder.append("cacheEntryExceptions=");
        builder.append(StringUtils.join(this.cacheEntryExceptions, (String)", "));
        builder.append("]");
        return builder.toString();
    }
}

