/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ExecutableFile {
    public static final ExecutableFile[] EMPTY_ARRAY = new ExecutableFile[0];
    public static final List<ExecutableFile> EMPTY_LIST = Lists.newArrayList();
    private final String file;
    private final String kind;

    public ExecutableFile(String file, String kind) {
        this.file = file;
        this.kind = kind;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExecutableFile) {
            ExecutableFile other = (ExecutableFile)obj;
            return ObjectUtilities.equals(other.file, this.file) && ObjectUtilities.equals(other.kind, this.kind);
        }
        return false;
    }

    public static ExecutableFile fromJson(JsonObject jsonObject) {
        String file = jsonObject.get("file").getAsString();
        String kind = jsonObject.get("kind").getAsString();
        return new ExecutableFile(file, kind);
    }

    public static List<ExecutableFile> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<ExecutableFile> list = new ArrayList<ExecutableFile>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(ExecutableFile.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public String getFile() {
        return this.file;
    }

    public String getKind() {
        return this.kind;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.file);
        builder.append((Object)this.kind);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("file", this.file);
        jsonObject.addProperty("kind", this.kind);
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("file=");
        builder.append(this.file + ", ");
        builder.append("kind=");
        builder.append(this.kind);
        builder.append("]");
        return builder.toString();
    }
}

