/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.JsonUtilities;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.RefactoringFeedback;

public class ExtractLocalVariableFeedback
extends RefactoringFeedback {
    public static final ExtractLocalVariableFeedback[] EMPTY_ARRAY = new ExtractLocalVariableFeedback[0];
    public static final List<ExtractLocalVariableFeedback> EMPTY_LIST = Lists.newArrayList();
    private final int[] coveringExpressionOffsets;
    private final int[] coveringExpressionLengths;
    private final List<String> names;
    private final int[] offsets;
    private final int[] lengths;

    public ExtractLocalVariableFeedback(int[] coveringExpressionOffsets, int[] coveringExpressionLengths, List<String> names, int[] offsets, int[] lengths) {
        this.coveringExpressionOffsets = coveringExpressionOffsets;
        this.coveringExpressionLengths = coveringExpressionLengths;
        this.names = names;
        this.offsets = offsets;
        this.lengths = lengths;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ExtractLocalVariableFeedback) {
            ExtractLocalVariableFeedback other = (ExtractLocalVariableFeedback)obj;
            return Arrays.equals(other.coveringExpressionOffsets, this.coveringExpressionOffsets) && Arrays.equals(other.coveringExpressionLengths, this.coveringExpressionLengths) && ObjectUtilities.equals(other.names, this.names) && Arrays.equals(other.offsets, this.offsets) && Arrays.equals(other.lengths, this.lengths);
        }
        return false;
    }

    public static ExtractLocalVariableFeedback fromJson(JsonObject jsonObject) {
        int[] coveringExpressionOffsets = jsonObject.get("coveringExpressionOffsets") == null ? null : JsonUtilities.decodeIntArray(jsonObject.get("coveringExpressionOffsets").getAsJsonArray());
        int[] coveringExpressionLengths = jsonObject.get("coveringExpressionLengths") == null ? null : JsonUtilities.decodeIntArray(jsonObject.get("coveringExpressionLengths").getAsJsonArray());
        List<String> names = JsonUtilities.decodeStringList(jsonObject.get("names").getAsJsonArray());
        int[] offsets = JsonUtilities.decodeIntArray(jsonObject.get("offsets").getAsJsonArray());
        int[] lengths = JsonUtilities.decodeIntArray(jsonObject.get("lengths").getAsJsonArray());
        return new ExtractLocalVariableFeedback(coveringExpressionOffsets, coveringExpressionLengths, names, offsets, lengths);
    }

    public static List<ExtractLocalVariableFeedback> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<ExtractLocalVariableFeedback> list = new ArrayList<ExtractLocalVariableFeedback>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(ExtractLocalVariableFeedback.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public int[] getCoveringExpressionLengths() {
        return this.coveringExpressionLengths;
    }

    public int[] getCoveringExpressionOffsets() {
        return this.coveringExpressionOffsets;
    }

    public int[] getLengths() {
        return this.lengths;
    }

    public List<String> getNames() {
        return this.names;
    }

    public int[] getOffsets() {
        return this.offsets;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.coveringExpressionOffsets);
        builder.append(this.coveringExpressionLengths);
        builder.append(this.names);
        builder.append(this.offsets);
        builder.append(this.lengths);
        return builder.toHashCode();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JsonObject toJson() {
        void var6_12;
        JsonObject jsonObject = new JsonObject();
        if (this.coveringExpressionOffsets != null) {
            JsonArray jsonArrayCoveringExpressionOffsets = new JsonArray();
            for (int n : this.coveringExpressionOffsets) {
                jsonArrayCoveringExpressionOffsets.add((JsonElement)new JsonPrimitive((Number)n));
            }
            jsonObject.add("coveringExpressionOffsets", (JsonElement)jsonArrayCoveringExpressionOffsets);
        }
        if (this.coveringExpressionLengths != null) {
            JsonArray jsonArrayCoveringExpressionLengths = new JsonArray();
            for (int n : this.coveringExpressionLengths) {
                jsonArrayCoveringExpressionLengths.add((JsonElement)new JsonPrimitive((Number)n));
            }
            jsonObject.add("coveringExpressionLengths", (JsonElement)jsonArrayCoveringExpressionLengths);
        }
        JsonArray jsonArrayNames = new JsonArray();
        Object object = this.names.iterator();
        while (object.hasNext()) {
            String elt = (String)object.next();
            jsonArrayNames.add((JsonElement)new JsonPrimitive(elt));
        }
        jsonObject.add("names", (JsonElement)jsonArrayNames);
        JsonArray jsonArrayOffsets = new JsonArray();
        int[] elt = this.offsets;
        int n = elt.length;
        boolean bl = false;
        while (var6_12 < n) {
            int elt2 = elt[var6_12];
            jsonArrayOffsets.add((JsonElement)new JsonPrimitive((Number)elt2));
            ++var6_12;
        }
        jsonObject.add("offsets", (JsonElement)jsonArrayOffsets);
        JsonArray jsonArrayLengths = new JsonArray();
        for (int elt3 : this.lengths) {
            jsonArrayLengths.add((JsonElement)new JsonPrimitive((Number)elt3));
        }
        jsonObject.add("lengths", (JsonElement)jsonArrayLengths);
        return jsonObject;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("coveringExpressionOffsets=");
        builder.append(StringUtils.join((Object[])new Serializable[]{this.coveringExpressionOffsets, ", "}) + ", ");
        builder.append("coveringExpressionLengths=");
        builder.append(StringUtils.join((Object[])new Serializable[]{this.coveringExpressionLengths, ", "}) + ", ");
        builder.append("names=");
        builder.append(StringUtils.join(this.names, (String)", ") + ", ");
        builder.append("offsets=");
        builder.append(StringUtils.join((Object[])new Serializable[]{this.offsets, ", "}) + ", ");
        builder.append("lengths=");
        builder.append(StringUtils.join((Object[])new Serializable[]{this.lengths, ", "}));
        builder.append("]");
        return builder.toString();
    }
}

