/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.RefactoringOptions;

public class ExtractLocalVariableOptions
extends RefactoringOptions {
    public static final ExtractLocalVariableOptions[] EMPTY_ARRAY = new ExtractLocalVariableOptions[0];
    public static final List<ExtractLocalVariableOptions> EMPTY_LIST = Lists.newArrayList();
    private String name;
    private boolean extractAll;

    public ExtractLocalVariableOptions(String name, boolean extractAll) {
        this.name = name;
        this.extractAll = extractAll;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ExtractLocalVariableOptions) {
            ExtractLocalVariableOptions other = (ExtractLocalVariableOptions)obj;
            return ObjectUtilities.equals(other.name, this.name) && other.extractAll == this.extractAll;
        }
        return false;
    }

    public static ExtractLocalVariableOptions fromJson(JsonObject jsonObject) {
        String name = jsonObject.get("name").getAsString();
        boolean extractAll = jsonObject.get("extractAll").getAsBoolean();
        return new ExtractLocalVariableOptions(name, extractAll);
    }

    public static List<ExtractLocalVariableOptions> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<ExtractLocalVariableOptions> list = new ArrayList<ExtractLocalVariableOptions>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(ExtractLocalVariableOptions.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public boolean extractAll() {
        return this.extractAll;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.name);
        builder.append(this.extractAll);
        return builder.toHashCode();
    }

    public void setExtractAll(boolean extractAll) {
        this.extractAll = extractAll;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", this.name);
        jsonObject.addProperty("extractAll", Boolean.valueOf(this.extractAll));
        return jsonObject;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("name=");
        builder.append(this.name + ", ");
        builder.append("extractAll=");
        builder.append(this.extractAll);
        builder.append("]");
        return builder.toString();
    }
}

