/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.RefactoringMethodParameter;
import org.dartlang.analysis.server.protocol.RefactoringOptions;

public class ExtractMethodOptions
extends RefactoringOptions {
    public static final ExtractMethodOptions[] EMPTY_ARRAY = new ExtractMethodOptions[0];
    public static final List<ExtractMethodOptions> EMPTY_LIST = Lists.newArrayList();
    private String returnType;
    private boolean createGetter;
    private String name;
    private List<RefactoringMethodParameter> parameters;
    private boolean extractAll;

    public ExtractMethodOptions(String returnType, boolean createGetter, String name, List<RefactoringMethodParameter> parameters, boolean extractAll) {
        this.returnType = returnType;
        this.createGetter = createGetter;
        this.name = name;
        this.parameters = parameters;
        this.extractAll = extractAll;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ExtractMethodOptions) {
            ExtractMethodOptions other = (ExtractMethodOptions)obj;
            return ObjectUtilities.equals(other.returnType, this.returnType) && other.createGetter == this.createGetter && ObjectUtilities.equals(other.name, this.name) && ObjectUtilities.equals(other.parameters, this.parameters) && other.extractAll == this.extractAll;
        }
        return false;
    }

    public static ExtractMethodOptions fromJson(JsonObject jsonObject) {
        String returnType = jsonObject.get("returnType").getAsString();
        boolean createGetter = jsonObject.get("createGetter").getAsBoolean();
        String name = jsonObject.get("name").getAsString();
        List<RefactoringMethodParameter> parameters = RefactoringMethodParameter.fromJsonArray(jsonObject.get("parameters").getAsJsonArray());
        boolean extractAll = jsonObject.get("extractAll").getAsBoolean();
        return new ExtractMethodOptions(returnType, createGetter, name, parameters, extractAll);
    }

    public static List<ExtractMethodOptions> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<ExtractMethodOptions> list = new ArrayList<ExtractMethodOptions>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(ExtractMethodOptions.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public boolean createGetter() {
        return this.createGetter;
    }

    public boolean extractAll() {
        return this.extractAll;
    }

    public String getName() {
        return this.name;
    }

    public List<RefactoringMethodParameter> getParameters() {
        return this.parameters;
    }

    public String getReturnType() {
        return this.returnType;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.returnType);
        builder.append(this.createGetter);
        builder.append((Object)this.name);
        builder.append(this.parameters);
        builder.append(this.extractAll);
        return builder.toHashCode();
    }

    public void setCreateGetter(boolean createGetter) {
        this.createGetter = createGetter;
    }

    public void setExtractAll(boolean extractAll) {
        this.extractAll = extractAll;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParameters(List<RefactoringMethodParameter> parameters) {
        this.parameters = parameters;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    @Override
    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("returnType", this.returnType);
        jsonObject.addProperty("createGetter", Boolean.valueOf(this.createGetter));
        jsonObject.addProperty("name", this.name);
        JsonArray jsonArrayParameters = new JsonArray();
        for (RefactoringMethodParameter elt : this.parameters) {
            jsonArrayParameters.add((JsonElement)elt.toJson());
        }
        jsonObject.add("parameters", (JsonElement)jsonArrayParameters);
        jsonObject.addProperty("extractAll", Boolean.valueOf(this.extractAll));
        return jsonObject;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("returnType=");
        builder.append(this.returnType + ", ");
        builder.append("createGetter=");
        builder.append(this.createGetter + ", ");
        builder.append("name=");
        builder.append(this.name + ", ");
        builder.append("parameters=");
        builder.append(StringUtils.join(this.parameters, (String)", ") + ", ");
        builder.append("extractAll=");
        builder.append(this.extractAll);
        builder.append("]");
        return builder.toString();
    }
}

