/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class FoldingRegion {
    public static final FoldingRegion[] EMPTY_ARRAY = new FoldingRegion[0];
    public static final List<FoldingRegion> EMPTY_LIST = Lists.newArrayList();
    private final String kind;
    private final int offset;
    private final int length;

    public FoldingRegion(String kind, int offset, int length) {
        this.kind = kind;
        this.offset = offset;
        this.length = length;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FoldingRegion) {
            FoldingRegion other = (FoldingRegion)obj;
            return ObjectUtilities.equals(other.kind, this.kind) && other.offset == this.offset && other.length == this.length;
        }
        return false;
    }

    public static FoldingRegion fromJson(JsonObject jsonObject) {
        String kind = jsonObject.get("kind").getAsString();
        int offset = jsonObject.get("offset").getAsInt();
        int length = jsonObject.get("length").getAsInt();
        return new FoldingRegion(kind, offset, length);
    }

    public static List<FoldingRegion> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<FoldingRegion> list = new ArrayList<FoldingRegion>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(FoldingRegion.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public String getKind() {
        return this.kind;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.kind);
        builder.append(this.offset);
        builder.append(this.length);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("kind", this.kind);
        jsonObject.addProperty("offset", (Number)this.offset);
        jsonObject.addProperty("length", (Number)this.length);
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("kind=");
        builder.append(this.kind + ", ");
        builder.append("offset=");
        builder.append(this.offset + ", ");
        builder.append("length=");
        builder.append(this.length);
        builder.append("]");
        return builder.toString();
    }
}

