/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class HoverInformation {
    public static final HoverInformation[] EMPTY_ARRAY = new HoverInformation[0];
    public static final List<HoverInformation> EMPTY_LIST = Lists.newArrayList();
    private final int offset;
    private final int length;
    private final String containingLibraryPath;
    private final String containingLibraryName;
    private final String containingClassDescription;
    private final String dartdoc;
    private final String elementDescription;
    private final String elementKind;
    private final Boolean isDeprecated;
    private final String parameter;
    private final String propagatedType;
    private final String staticType;

    public HoverInformation(int offset, int length, String containingLibraryPath, String containingLibraryName, String containingClassDescription, String dartdoc, String elementDescription, String elementKind, Boolean isDeprecated, String parameter, String propagatedType, String staticType) {
        this.offset = offset;
        this.length = length;
        this.containingLibraryPath = containingLibraryPath;
        this.containingLibraryName = containingLibraryName;
        this.containingClassDescription = containingClassDescription;
        this.dartdoc = dartdoc;
        this.elementDescription = elementDescription;
        this.elementKind = elementKind;
        this.isDeprecated = isDeprecated;
        this.parameter = parameter;
        this.propagatedType = propagatedType;
        this.staticType = staticType;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HoverInformation) {
            HoverInformation other = (HoverInformation)obj;
            return other.offset == this.offset && other.length == this.length && ObjectUtilities.equals(other.containingLibraryPath, this.containingLibraryPath) && ObjectUtilities.equals(other.containingLibraryName, this.containingLibraryName) && ObjectUtilities.equals(other.containingClassDescription, this.containingClassDescription) && ObjectUtilities.equals(other.dartdoc, this.dartdoc) && ObjectUtilities.equals(other.elementDescription, this.elementDescription) && ObjectUtilities.equals(other.elementKind, this.elementKind) && ObjectUtilities.equals(other.isDeprecated, this.isDeprecated) && ObjectUtilities.equals(other.parameter, this.parameter) && ObjectUtilities.equals(other.propagatedType, this.propagatedType) && ObjectUtilities.equals(other.staticType, this.staticType);
        }
        return false;
    }

    public static HoverInformation fromJson(JsonObject jsonObject) {
        int offset = jsonObject.get("offset").getAsInt();
        int length = jsonObject.get("length").getAsInt();
        String containingLibraryPath = jsonObject.get("containingLibraryPath") == null ? null : jsonObject.get("containingLibraryPath").getAsString();
        String containingLibraryName = jsonObject.get("containingLibraryName") == null ? null : jsonObject.get("containingLibraryName").getAsString();
        String containingClassDescription = jsonObject.get("containingClassDescription") == null ? null : jsonObject.get("containingClassDescription").getAsString();
        String dartdoc = jsonObject.get("dartdoc") == null ? null : jsonObject.get("dartdoc").getAsString();
        String elementDescription = jsonObject.get("elementDescription") == null ? null : jsonObject.get("elementDescription").getAsString();
        String elementKind = jsonObject.get("elementKind") == null ? null : jsonObject.get("elementKind").getAsString();
        Boolean isDeprecated = jsonObject.get("isDeprecated") == null ? null : Boolean.valueOf(jsonObject.get("isDeprecated").getAsBoolean());
        String parameter = jsonObject.get("parameter") == null ? null : jsonObject.get("parameter").getAsString();
        String propagatedType = jsonObject.get("propagatedType") == null ? null : jsonObject.get("propagatedType").getAsString();
        String staticType = jsonObject.get("staticType") == null ? null : jsonObject.get("staticType").getAsString();
        return new HoverInformation(offset, length, containingLibraryPath, containingLibraryName, containingClassDescription, dartdoc, elementDescription, elementKind, isDeprecated, parameter, propagatedType, staticType);
    }

    public static List<HoverInformation> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<HoverInformation> list = new ArrayList<HoverInformation>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(HoverInformation.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public String getContainingClassDescription() {
        return this.containingClassDescription;
    }

    public String getContainingLibraryName() {
        return this.containingLibraryName;
    }

    public String getContainingLibraryPath() {
        return this.containingLibraryPath;
    }

    public String getDartdoc() {
        return this.dartdoc;
    }

    public String getElementDescription() {
        return this.elementDescription;
    }

    public String getElementKind() {
        return this.elementKind;
    }

    public Boolean getIsDeprecated() {
        return this.isDeprecated;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getParameter() {
        return this.parameter;
    }

    public String getPropagatedType() {
        return this.propagatedType;
    }

    public String getStaticType() {
        return this.staticType;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.offset);
        builder.append(this.length);
        builder.append((Object)this.containingLibraryPath);
        builder.append((Object)this.containingLibraryName);
        builder.append((Object)this.containingClassDescription);
        builder.append((Object)this.dartdoc);
        builder.append((Object)this.elementDescription);
        builder.append((Object)this.elementKind);
        builder.append((Object)this.isDeprecated);
        builder.append((Object)this.parameter);
        builder.append((Object)this.propagatedType);
        builder.append((Object)this.staticType);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("offset", (Number)this.offset);
        jsonObject.addProperty("length", (Number)this.length);
        if (this.containingLibraryPath != null) {
            jsonObject.addProperty("containingLibraryPath", this.containingLibraryPath);
        }
        if (this.containingLibraryName != null) {
            jsonObject.addProperty("containingLibraryName", this.containingLibraryName);
        }
        if (this.containingClassDescription != null) {
            jsonObject.addProperty("containingClassDescription", this.containingClassDescription);
        }
        if (this.dartdoc != null) {
            jsonObject.addProperty("dartdoc", this.dartdoc);
        }
        if (this.elementDescription != null) {
            jsonObject.addProperty("elementDescription", this.elementDescription);
        }
        if (this.elementKind != null) {
            jsonObject.addProperty("elementKind", this.elementKind);
        }
        if (this.isDeprecated != null) {
            jsonObject.addProperty("isDeprecated", this.isDeprecated);
        }
        if (this.parameter != null) {
            jsonObject.addProperty("parameter", this.parameter);
        }
        if (this.propagatedType != null) {
            jsonObject.addProperty("propagatedType", this.propagatedType);
        }
        if (this.staticType != null) {
            jsonObject.addProperty("staticType", this.staticType);
        }
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("offset=");
        builder.append(this.offset + ", ");
        builder.append("length=");
        builder.append(this.length + ", ");
        builder.append("containingLibraryPath=");
        builder.append(this.containingLibraryPath + ", ");
        builder.append("containingLibraryName=");
        builder.append(this.containingLibraryName + ", ");
        builder.append("containingClassDescription=");
        builder.append(this.containingClassDescription + ", ");
        builder.append("dartdoc=");
        builder.append(this.dartdoc + ", ");
        builder.append("elementDescription=");
        builder.append(this.elementDescription + ", ");
        builder.append("elementKind=");
        builder.append(this.elementKind + ", ");
        builder.append("isDeprecated=");
        builder.append(this.isDeprecated + ", ");
        builder.append("parameter=");
        builder.append(this.parameter + ", ");
        builder.append("propagatedType=");
        builder.append(this.propagatedType + ", ");
        builder.append("staticType=");
        builder.append(this.staticType);
        builder.append("]");
        return builder.toString();
    }
}

