/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.RefactoringFeedback;

public class InlineLocalVariableFeedback
extends RefactoringFeedback {
    public static final InlineLocalVariableFeedback[] EMPTY_ARRAY = new InlineLocalVariableFeedback[0];
    public static final List<InlineLocalVariableFeedback> EMPTY_LIST = Lists.newArrayList();
    private final String name;
    private final int occurrences;

    public InlineLocalVariableFeedback(String name, int occurrences) {
        this.name = name;
        this.occurrences = occurrences;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof InlineLocalVariableFeedback) {
            InlineLocalVariableFeedback other = (InlineLocalVariableFeedback)obj;
            return ObjectUtilities.equals(other.name, this.name) && other.occurrences == this.occurrences;
        }
        return false;
    }

    public static InlineLocalVariableFeedback fromJson(JsonObject jsonObject) {
        String name = jsonObject.get("name").getAsString();
        int occurrences = jsonObject.get("occurrences").getAsInt();
        return new InlineLocalVariableFeedback(name, occurrences);
    }

    public static List<InlineLocalVariableFeedback> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<InlineLocalVariableFeedback> list = new ArrayList<InlineLocalVariableFeedback>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(InlineLocalVariableFeedback.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public String getName() {
        return this.name;
    }

    public int getOccurrences() {
        return this.occurrences;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.name);
        builder.append(this.occurrences);
        return builder.toHashCode();
    }

    @Override
    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", this.name);
        jsonObject.addProperty("occurrences", (Number)this.occurrences);
        return jsonObject;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("name=");
        builder.append(this.name + ", ");
        builder.append("occurrences=");
        builder.append(this.occurrences);
        builder.append("]");
        return builder.toString();
    }
}

