/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.RefactoringOptions;

public class InlineMethodOptions
extends RefactoringOptions {
    public static final InlineMethodOptions[] EMPTY_ARRAY = new InlineMethodOptions[0];
    public static final List<InlineMethodOptions> EMPTY_LIST = Lists.newArrayList();
    private boolean deleteSource;
    private boolean inlineAll;

    public InlineMethodOptions(boolean deleteSource, boolean inlineAll) {
        this.deleteSource = deleteSource;
        this.inlineAll = inlineAll;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof InlineMethodOptions) {
            InlineMethodOptions other = (InlineMethodOptions)obj;
            return other.deleteSource == this.deleteSource && other.inlineAll == this.inlineAll;
        }
        return false;
    }

    public static InlineMethodOptions fromJson(JsonObject jsonObject) {
        boolean deleteSource = jsonObject.get("deleteSource").getAsBoolean();
        boolean inlineAll = jsonObject.get("inlineAll").getAsBoolean();
        return new InlineMethodOptions(deleteSource, inlineAll);
    }

    public static List<InlineMethodOptions> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<InlineMethodOptions> list = new ArrayList<InlineMethodOptions>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(InlineMethodOptions.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public boolean deleteSource() {
        return this.deleteSource;
    }

    public boolean inlineAll() {
        return this.inlineAll;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.deleteSource);
        builder.append(this.inlineAll);
        return builder.toHashCode();
    }

    public void setDeleteSource(boolean deleteSource) {
        this.deleteSource = deleteSource;
    }

    public void setInlineAll(boolean inlineAll) {
        this.inlineAll = inlineAll;
    }

    @Override
    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("deleteSource", Boolean.valueOf(this.deleteSource));
        jsonObject.addProperty("inlineAll", Boolean.valueOf(this.inlineAll));
        return jsonObject;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("deleteSource=");
        builder.append(this.deleteSource + ", ");
        builder.append("inlineAll=");
        builder.append(this.inlineAll);
        builder.append("]");
        return builder.toString();
    }
}

