/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Location {
    public static final Location[] EMPTY_ARRAY = new Location[0];
    public static final List<Location> EMPTY_LIST = Lists.newArrayList();
    private final String file;
    private final int offset;
    private final int length;
    private final int startLine;
    private final int startColumn;

    public Location(String file, int offset, int length, int startLine, int startColumn) {
        this.file = file;
        this.offset = offset;
        this.length = length;
        this.startLine = startLine;
        this.startColumn = startColumn;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Location) {
            Location other = (Location)obj;
            return ObjectUtilities.equals(other.file, this.file) && other.offset == this.offset && other.length == this.length && other.startLine == this.startLine && other.startColumn == this.startColumn;
        }
        return false;
    }

    public static Location fromJson(JsonObject jsonObject) {
        String file = jsonObject.get("file").getAsString();
        int offset = jsonObject.get("offset").getAsInt();
        int length = jsonObject.get("length").getAsInt();
        int startLine = jsonObject.get("startLine").getAsInt();
        int startColumn = jsonObject.get("startColumn").getAsInt();
        return new Location(file, offset, length, startLine, startColumn);
    }

    public static List<Location> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<Location> list = new ArrayList<Location>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(Location.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public String getFile() {
        return this.file;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.file);
        builder.append(this.offset);
        builder.append(this.length);
        builder.append(this.startLine);
        builder.append(this.startColumn);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("file", this.file);
        jsonObject.addProperty("offset", (Number)this.offset);
        jsonObject.addProperty("length", (Number)this.length);
        jsonObject.addProperty("startLine", (Number)this.startLine);
        jsonObject.addProperty("startColumn", (Number)this.startColumn);
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("file=");
        builder.append(this.file + ", ");
        builder.append("offset=");
        builder.append(this.offset + ", ");
        builder.append("length=");
        builder.append(this.length + ", ");
        builder.append("startLine=");
        builder.append(this.startLine + ", ");
        builder.append("startColumn=");
        builder.append(this.startColumn);
        builder.append("]");
        return builder.toString();
    }
}

