/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.RefactoringOptions;

public class MoveFileOptions
extends RefactoringOptions {
    public static final MoveFileOptions[] EMPTY_ARRAY = new MoveFileOptions[0];
    public static final List<MoveFileOptions> EMPTY_LIST = Lists.newArrayList();
    private String newFile;

    public MoveFileOptions(String newFile) {
        this.newFile = newFile;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MoveFileOptions) {
            MoveFileOptions other = (MoveFileOptions)obj;
            return ObjectUtilities.equals(other.newFile, this.newFile);
        }
        return false;
    }

    public static MoveFileOptions fromJson(JsonObject jsonObject) {
        String newFile = jsonObject.get("newFile").getAsString();
        return new MoveFileOptions(newFile);
    }

    public static List<MoveFileOptions> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<MoveFileOptions> list = new ArrayList<MoveFileOptions>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(MoveFileOptions.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public String getNewFile() {
        return this.newFile;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.newFile);
        return builder.toHashCode();
    }

    public void setNewFile(String newFile) {
        this.newFile = newFile;
    }

    @Override
    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("newFile", this.newFile);
        return jsonObject;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("newFile=");
        builder.append(this.newFile);
        builder.append("]");
        return builder.toString();
    }
}

