/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.JsonUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.NavigationTarget;

public class NavigationRegion {
    public static final NavigationRegion[] EMPTY_ARRAY = new NavigationRegion[0];
    public static final List<NavigationRegion> EMPTY_LIST = Lists.newArrayList();
    private final int offset;
    private final int length;
    private final int[] targets;
    private final List<NavigationTarget> targetObjects = Lists.newArrayList();

    public NavigationRegion(int offset, int length, int[] targets) {
        this.offset = offset;
        this.length = length;
        this.targets = targets;
    }

    public boolean containsInclusive(int x) {
        return this.offset <= x && x <= this.offset + this.length;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NavigationRegion) {
            NavigationRegion other = (NavigationRegion)obj;
            return other.offset == this.offset && other.length == this.length && Arrays.equals(other.targets, this.targets);
        }
        return false;
    }

    public static NavigationRegion fromJson(JsonObject jsonObject) {
        int offset = jsonObject.get("offset").getAsInt();
        int length = jsonObject.get("length").getAsInt();
        int[] targets = JsonUtilities.decodeIntArray(jsonObject.get("targets").getAsJsonArray());
        return new NavigationRegion(offset, length, targets);
    }

    public static List<NavigationRegion> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<NavigationRegion> list = new ArrayList<NavigationRegion>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(NavigationRegion.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public List<NavigationTarget> getTargetObjects() {
        return this.targetObjects;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public int[] getTargets() {
        return this.targets;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.offset);
        builder.append(this.length);
        builder.append(this.targets);
        return builder.toHashCode();
    }

    public void lookupTargets(List<NavigationTarget> allTargets) {
        for (int i = 0; i < this.targets.length; ++i) {
            int targetIndex = this.targets[i];
            NavigationTarget target = allTargets.get(targetIndex);
            this.targetObjects.add(target);
        }
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("offset", (Number)this.offset);
        jsonObject.addProperty("length", (Number)this.length);
        JsonArray jsonArrayTargets = new JsonArray();
        for (int elt : this.targets) {
            jsonArrayTargets.add((JsonElement)new JsonPrimitive((Number)elt));
        }
        jsonObject.add("targets", (JsonElement)jsonArrayTargets);
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("offset=");
        builder.append(this.offset + ", ");
        builder.append("length=");
        builder.append(this.length + ", ");
        builder.append("targets=");
        builder.append(StringUtils.join((Object[])new Serializable[]{this.targets, ", "}));
        builder.append("]");
        return builder.toString();
    }
}

