/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.JsonUtilities;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.Element;

public class Occurrences {
    public static final Occurrences[] EMPTY_ARRAY = new Occurrences[0];
    public static final List<Occurrences> EMPTY_LIST = Lists.newArrayList();
    private final Element element;
    private final int[] offsets;
    private final int length;

    public Occurrences(Element element, int[] offsets, int length) {
        this.element = element;
        this.offsets = offsets;
        this.length = length;
    }

    public boolean containsInclusive(int x) {
        for (int offset : this.offsets) {
            if (offset > x || x > offset + this.length) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Occurrences) {
            Occurrences other = (Occurrences)obj;
            return ObjectUtilities.equals(other.element, this.element) && Arrays.equals(other.offsets, this.offsets) && other.length == this.length;
        }
        return false;
    }

    public static Occurrences fromJson(JsonObject jsonObject) {
        Element element = Element.fromJson(jsonObject.get("element").getAsJsonObject());
        int[] offsets = JsonUtilities.decodeIntArray(jsonObject.get("offsets").getAsJsonArray());
        int length = jsonObject.get("length").getAsInt();
        return new Occurrences(element, offsets, length);
    }

    public static List<Occurrences> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<Occurrences> list = new ArrayList<Occurrences>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(Occurrences.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public Element getElement() {
        return this.element;
    }

    public int getLength() {
        return this.length;
    }

    public int[] getOffsets() {
        return this.offsets;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.element);
        builder.append(this.offsets);
        builder.append(this.length);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("element", (JsonElement)this.element.toJson());
        JsonArray jsonArrayOffsets = new JsonArray();
        for (int elt : this.offsets) {
            jsonArrayOffsets.add((JsonElement)new JsonPrimitive((Number)elt));
        }
        jsonObject.add("offsets", (JsonElement)jsonArrayOffsets);
        jsonObject.addProperty("length", (Number)this.length);
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("element=");
        builder.append(this.element + ", ");
        builder.append("offsets=");
        builder.append(StringUtils.join((Object[])new Serializable[]{this.offsets, ", "}) + ", ");
        builder.append("length=");
        builder.append(this.length);
        builder.append("]");
        return builder.toString();
    }
}

