/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.Element;

public class Outline {
    public static final Outline[] EMPTY_ARRAY = new Outline[0];
    public static final List<Outline> EMPTY_LIST = Lists.newArrayList();
    private Element element;
    private int offset;
    private int length;
    private final Outline parent;
    private List<Outline> children;

    public Outline(Outline parent, Element element, int offset, int length) {
        this.parent = parent;
        this.element = element;
        this.offset = offset;
        this.length = length;
    }

    public boolean containsInclusive(int x) {
        return this.offset <= x && x <= this.offset + this.length;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Outline) {
            Outline other = (Outline)obj;
            return ObjectUtilities.equals(other.element, this.element) && other.offset == this.offset && other.length == this.length && ObjectUtilities.equals(other.children, this.children);
        }
        return false;
    }

    public static Outline fromJson(Outline parent, JsonObject outlineObject) {
        JsonObject elementObject = outlineObject.get("element").getAsJsonObject();
        Element element = Element.fromJson(elementObject);
        int offset = outlineObject.get("offset").getAsInt();
        int length = outlineObject.get("length").getAsInt();
        Outline outline = new Outline(parent, element, offset, length);
        ArrayList childrenList = Lists.newArrayList();
        JsonElement childrenJsonArray = outlineObject.get("children");
        if (childrenJsonArray instanceof JsonArray) {
            Iterator childrenElementIterator = ((JsonArray)childrenJsonArray).iterator();
            while (childrenElementIterator.hasNext()) {
                JsonObject childObject = ((JsonElement)childrenElementIterator.next()).getAsJsonObject();
                childrenList.add(Outline.fromJson(outline, childObject));
            }
        }
        outline.setChildren(childrenList);
        return outline;
    }

    public Outline getParent() {
        return this.parent;
    }

    public List<Outline> getChildren() {
        return this.children;
    }

    public Element getElement() {
        return this.element;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.element);
        builder.append(this.offset);
        builder.append(this.length);
        builder.append(this.children);
        return builder.toHashCode();
    }

    public void setChildren(List<Outline> children) {
        this.children = children;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("element=");
        builder.append(this.element + ", ");
        builder.append("offset=");
        builder.append(this.offset + ", ");
        builder.append("length=");
        builder.append(this.length + ", ");
        builder.append("children=");
        builder.append(StringUtils.join(this.children, (String)", "));
        builder.append("]");
        return builder.toString();
    }
}

