/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.OverriddenMember;

public class OverrideMember {
    public static final OverrideMember[] EMPTY_ARRAY = new OverrideMember[0];
    public static final List<OverrideMember> EMPTY_LIST = Lists.newArrayList();
    private final int offset;
    private final int length;
    private final OverriddenMember superclassMember;
    private final List<OverriddenMember> interfaceMembers;

    public OverrideMember(int offset, int length, OverriddenMember superclassMember, List<OverriddenMember> interfaceMembers) {
        this.offset = offset;
        this.length = length;
        this.superclassMember = superclassMember;
        this.interfaceMembers = interfaceMembers;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OverrideMember) {
            OverrideMember other = (OverrideMember)obj;
            return other.offset == this.offset && other.length == this.length && ObjectUtilities.equals(other.superclassMember, this.superclassMember) && ObjectUtilities.equals(other.interfaceMembers, this.interfaceMembers);
        }
        return false;
    }

    public static OverrideMember fromJson(JsonObject jsonObject) {
        int offset = jsonObject.get("offset").getAsInt();
        int length = jsonObject.get("length").getAsInt();
        OverriddenMember superclassMember = jsonObject.get("superclassMember") == null ? null : OverriddenMember.fromJson(jsonObject.get("superclassMember").getAsJsonObject());
        List<OverriddenMember> interfaceMembers = jsonObject.get("interfaceMembers") == null ? null : OverriddenMember.fromJsonArray(jsonObject.get("interfaceMembers").getAsJsonArray());
        return new OverrideMember(offset, length, superclassMember, interfaceMembers);
    }

    public static List<OverrideMember> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<OverrideMember> list = new ArrayList<OverrideMember>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(OverrideMember.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public List<OverriddenMember> getInterfaceMembers() {
        return this.interfaceMembers;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public OverriddenMember getSuperclassMember() {
        return this.superclassMember;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.offset);
        builder.append(this.length);
        builder.append((Object)this.superclassMember);
        builder.append(this.interfaceMembers);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("offset", (Number)this.offset);
        jsonObject.addProperty("length", (Number)this.length);
        if (this.superclassMember != null) {
            jsonObject.add("superclassMember", (JsonElement)this.superclassMember.toJson());
        }
        if (this.interfaceMembers != null) {
            JsonArray jsonArrayInterfaceMembers = new JsonArray();
            for (OverriddenMember elt : this.interfaceMembers) {
                jsonArrayInterfaceMembers.add((JsonElement)elt.toJson());
            }
            jsonObject.add("interfaceMembers", (JsonElement)jsonArrayInterfaceMembers);
        }
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("offset=");
        builder.append(this.offset + ", ");
        builder.append("length=");
        builder.append(this.length + ", ");
        builder.append("superclassMember=");
        builder.append(this.superclassMember + ", ");
        builder.append("interfaceMembers=");
        builder.append(StringUtils.join(this.interfaceMembers, (String)", "));
        builder.append("]");
        return builder.toString();
    }
}

