/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Position {
    public static final Position[] EMPTY_ARRAY = new Position[0];
    public static final List<Position> EMPTY_LIST = Lists.newArrayList();
    private final String file;
    private final int offset;

    public Position(String file, int offset) {
        this.file = file;
        this.offset = offset;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Position) {
            Position other = (Position)obj;
            return ObjectUtilities.equals(other.file, this.file) && other.offset == this.offset;
        }
        return false;
    }

    public static Position fromJson(JsonObject jsonObject) {
        String file = jsonObject.get("file").getAsString();
        int offset = jsonObject.get("offset").getAsInt();
        return new Position(file, offset);
    }

    public static List<Position> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<Position> list = new ArrayList<Position>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(Position.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public String getFile() {
        return this.file;
    }

    public int getOffset() {
        return this.offset;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.file);
        builder.append(this.offset);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("file", this.file);
        jsonObject.addProperty("offset", (Number)this.offset);
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("file=");
        builder.append(this.file + ", ");
        builder.append("offset=");
        builder.append(this.offset);
        builder.append("]");
        return builder.toString();
    }
}

