/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.Location;

public class RefactoringProblem {
    public static final RefactoringProblem[] EMPTY_ARRAY = new RefactoringProblem[0];
    public static final List<RefactoringProblem> EMPTY_LIST = Lists.newArrayList();
    private final String severity;
    private final String message;
    private final Location location;

    public RefactoringProblem(String severity, String message, Location location) {
        this.severity = severity;
        this.message = message;
        this.location = location;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RefactoringProblem) {
            RefactoringProblem other = (RefactoringProblem)obj;
            return ObjectUtilities.equals(other.severity, this.severity) && ObjectUtilities.equals(other.message, this.message) && ObjectUtilities.equals(other.location, this.location);
        }
        return false;
    }

    public static RefactoringProblem fromJson(JsonObject jsonObject) {
        String severity = jsonObject.get("severity").getAsString();
        String message = jsonObject.get("message").getAsString();
        Location location = jsonObject.get("location") == null ? null : Location.fromJson(jsonObject.get("location").getAsJsonObject());
        return new RefactoringProblem(severity, message, location);
    }

    public static List<RefactoringProblem> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<RefactoringProblem> list = new ArrayList<RefactoringProblem>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(RefactoringProblem.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSeverity() {
        return this.severity;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.severity);
        builder.append((Object)this.message);
        builder.append((Object)this.location);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("severity", this.severity);
        jsonObject.addProperty("message", this.message);
        if (this.location != null) {
            jsonObject.add("location", (JsonElement)this.location.toJson());
        }
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("severity=");
        builder.append(this.severity + ", ");
        builder.append("message=");
        builder.append(this.message + ", ");
        builder.append("location=");
        builder.append(this.location);
        builder.append("]");
        return builder.toString();
    }
}

