/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.RefactoringOptions;

public class RenameOptions
extends RefactoringOptions {
    public static final RenameOptions[] EMPTY_ARRAY = new RenameOptions[0];
    public static final List<RenameOptions> EMPTY_LIST = Lists.newArrayList();
    private String newName;

    public RenameOptions(String newName) {
        this.newName = newName;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RenameOptions) {
            RenameOptions other = (RenameOptions)obj;
            return ObjectUtilities.equals(other.newName, this.newName);
        }
        return false;
    }

    public static RenameOptions fromJson(JsonObject jsonObject) {
        String newName = jsonObject.get("newName").getAsString();
        return new RenameOptions(newName);
    }

    public static List<RenameOptions> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<RenameOptions> list = new ArrayList<RenameOptions>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(RenameOptions.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public String getNewName() {
        return this.newName;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.newName);
        return builder.toHashCode();
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    @Override
    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("newName", this.newName);
        return jsonObject;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("newName=");
        builder.append(this.newName);
        builder.append("]");
        return builder.toString();
    }
}

