/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.Element;
import org.dartlang.analysis.server.protocol.Location;

public class SearchResult {
    public static final SearchResult[] EMPTY_ARRAY = new SearchResult[0];
    public static final List<SearchResult> EMPTY_LIST = Lists.newArrayList();
    private final Location location;
    private final String kind;
    private final boolean isPotential;
    private final List<Element> path;

    public SearchResult(Location location, String kind, boolean isPotential, List<Element> path) {
        this.location = location;
        this.kind = kind;
        this.isPotential = isPotential;
        this.path = path;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SearchResult) {
            SearchResult other = (SearchResult)obj;
            return ObjectUtilities.equals(other.location, this.location) && ObjectUtilities.equals(other.kind, this.kind) && other.isPotential == this.isPotential && ObjectUtilities.equals(other.path, this.path);
        }
        return false;
    }

    public static SearchResult fromJson(JsonObject jsonObject) {
        Location location = Location.fromJson(jsonObject.get("location").getAsJsonObject());
        String kind = jsonObject.get("kind").getAsString();
        boolean isPotential = jsonObject.get("isPotential").getAsBoolean();
        List<Element> path = Element.fromJsonArray(jsonObject.get("path").getAsJsonArray());
        return new SearchResult(location, kind, isPotential, path);
    }

    public static List<SearchResult> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<SearchResult> list = new ArrayList<SearchResult>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(SearchResult.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public boolean isPotential() {
        return this.isPotential;
    }

    public String getKind() {
        return this.kind;
    }

    public Location getLocation() {
        return this.location;
    }

    public List<Element> getPath() {
        return this.path;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.location);
        builder.append((Object)this.kind);
        builder.append(this.isPotential);
        builder.append(this.path);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("location", (JsonElement)this.location.toJson());
        jsonObject.addProperty("kind", this.kind);
        jsonObject.addProperty("isPotential", Boolean.valueOf(this.isPotential));
        JsonArray jsonArrayPath = new JsonArray();
        for (Element elt : this.path) {
            jsonArrayPath.add((JsonElement)elt.toJson());
        }
        jsonObject.add("path", (JsonElement)jsonArrayPath);
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("location=");
        builder.append(this.location + ", ");
        builder.append("kind=");
        builder.append(this.kind + ", ");
        builder.append("isPotential=");
        builder.append(this.isPotential + ", ");
        builder.append("path=");
        builder.append(StringUtils.join(this.path, (String)", "));
        builder.append("]");
        return builder.toString();
    }
}

