/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.LinkedEditGroup;
import org.dartlang.analysis.server.protocol.Position;
import org.dartlang.analysis.server.protocol.SourceFileEdit;

public class SourceChange {
    public static final SourceChange[] EMPTY_ARRAY = new SourceChange[0];
    public static final List<SourceChange> EMPTY_LIST = Lists.newArrayList();
    private final String message;
    private final List<SourceFileEdit> edits;
    private final List<LinkedEditGroup> linkedEditGroups;
    private final Position selection;

    public SourceChange(String message, List<SourceFileEdit> edits, List<LinkedEditGroup> linkedEditGroups, Position selection) {
        this.message = message;
        this.edits = edits;
        this.linkedEditGroups = linkedEditGroups;
        this.selection = selection;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SourceChange) {
            SourceChange other = (SourceChange)obj;
            return ObjectUtilities.equals(other.message, this.message) && ObjectUtilities.equals(other.edits, this.edits) && ObjectUtilities.equals(other.linkedEditGroups, this.linkedEditGroups) && ObjectUtilities.equals(other.selection, this.selection);
        }
        return false;
    }

    public static SourceChange fromJson(JsonObject jsonObject) {
        String message = jsonObject.get("message").getAsString();
        List<SourceFileEdit> edits = SourceFileEdit.fromJsonArray(jsonObject.get("edits").getAsJsonArray());
        List<LinkedEditGroup> linkedEditGroups = LinkedEditGroup.fromJsonArray(jsonObject.get("linkedEditGroups").getAsJsonArray());
        Position selection = jsonObject.get("selection") == null ? null : Position.fromJson(jsonObject.get("selection").getAsJsonObject());
        return new SourceChange(message, edits, linkedEditGroups, selection);
    }

    public static List<SourceChange> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<SourceChange> list = new ArrayList<SourceChange>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(SourceChange.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public List<SourceFileEdit> getEdits() {
        return this.edits;
    }

    public List<LinkedEditGroup> getLinkedEditGroups() {
        return this.linkedEditGroups;
    }

    public String getMessage() {
        return this.message;
    }

    public Position getSelection() {
        return this.selection;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.message);
        builder.append(this.edits);
        builder.append(this.linkedEditGroups);
        builder.append((Object)this.selection);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("message", this.message);
        JsonArray jsonArrayEdits = new JsonArray();
        for (SourceFileEdit elt : this.edits) {
            jsonArrayEdits.add((JsonElement)elt.toJson());
        }
        jsonObject.add("edits", (JsonElement)jsonArrayEdits);
        JsonArray jsonArrayLinkedEditGroups = new JsonArray();
        for (LinkedEditGroup elt : this.linkedEditGroups) {
            jsonArrayLinkedEditGroups.add((JsonElement)elt.toJson());
        }
        jsonObject.add("linkedEditGroups", (JsonElement)jsonArrayLinkedEditGroups);
        if (this.selection != null) {
            jsonObject.add("selection", (JsonElement)this.selection.toJson());
        }
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("message=");
        builder.append(this.message + ", ");
        builder.append("edits=");
        builder.append(StringUtils.join(this.edits, (String)", ") + ", ");
        builder.append("linkedEditGroups=");
        builder.append(StringUtils.join(this.linkedEditGroups, (String)", ") + ", ");
        builder.append("selection=");
        builder.append(this.selection);
        builder.append("]");
        return builder.toString();
    }
}

