/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SourceEdit {
    public static final SourceEdit[] EMPTY_ARRAY = new SourceEdit[0];
    public static final List<SourceEdit> EMPTY_LIST = Lists.newArrayList();
    private final int offset;
    private final int length;
    private final String replacement;
    private final String id;

    public SourceEdit(int offset, int length, String replacement, String id) {
        this.offset = offset;
        this.length = length;
        this.replacement = replacement;
        this.id = id;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SourceEdit) {
            SourceEdit other = (SourceEdit)obj;
            return other.offset == this.offset && other.length == this.length && ObjectUtilities.equals(other.replacement, this.replacement) && ObjectUtilities.equals(other.id, this.id);
        }
        return false;
    }

    public static SourceEdit fromJson(JsonObject jsonObject) {
        int offset = jsonObject.get("offset").getAsInt();
        int length = jsonObject.get("length").getAsInt();
        String replacement = jsonObject.get("replacement").getAsString();
        String id = jsonObject.get("id") == null ? null : jsonObject.get("id").getAsString();
        return new SourceEdit(offset, length, replacement, id);
    }

    public static List<SourceEdit> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<SourceEdit> list = new ArrayList<SourceEdit>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(SourceEdit.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public String getId() {
        return this.id;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.offset);
        builder.append(this.length);
        builder.append((Object)this.replacement);
        builder.append((Object)this.id);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("offset", (Number)this.offset);
        jsonObject.addProperty("length", (Number)this.length);
        jsonObject.addProperty("replacement", this.replacement);
        if (this.id != null) {
            jsonObject.addProperty("id", this.id);
        }
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("offset=");
        builder.append(this.offset + ", ");
        builder.append("length=");
        builder.append(this.length + ", ");
        builder.append("replacement=");
        builder.append(this.replacement + ", ");
        builder.append("id=");
        builder.append(this.id);
        builder.append("]");
        return builder.toString();
    }
}

