/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.SourceEdit;

public class SourceFileEdit {
    public static final SourceFileEdit[] EMPTY_ARRAY = new SourceFileEdit[0];
    public static final List<SourceFileEdit> EMPTY_LIST = Lists.newArrayList();
    private final String file;
    private final long fileStamp;
    private final List<SourceEdit> edits;

    public SourceFileEdit(String file, long fileStamp, List<SourceEdit> edits) {
        this.file = file;
        this.fileStamp = fileStamp;
        this.edits = edits;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SourceFileEdit) {
            SourceFileEdit other = (SourceFileEdit)obj;
            return ObjectUtilities.equals(other.file, this.file) && other.fileStamp == this.fileStamp && ObjectUtilities.equals(other.edits, this.edits);
        }
        return false;
    }

    public static SourceFileEdit fromJson(JsonObject jsonObject) {
        String file = jsonObject.get("file").getAsString();
        long fileStamp = jsonObject.get("fileStamp").getAsLong();
        List<SourceEdit> edits = SourceEdit.fromJsonArray(jsonObject.get("edits").getAsJsonArray());
        return new SourceFileEdit(file, fileStamp, edits);
    }

    public static List<SourceFileEdit> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<SourceFileEdit> list = new ArrayList<SourceFileEdit>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(SourceFileEdit.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public List<SourceEdit> getEdits() {
        return this.edits;
    }

    public String getFile() {
        return this.file;
    }

    public long getFileStamp() {
        return this.fileStamp;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.file);
        builder.append(this.fileStamp);
        builder.append(this.edits);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("file", this.file);
        jsonObject.addProperty("fileStamp", (Number)this.fileStamp);
        JsonArray jsonArrayEdits = new JsonArray();
        for (SourceEdit elt : this.edits) {
            jsonArrayEdits.add((JsonElement)elt.toJson());
        }
        jsonObject.add("edits", (JsonElement)jsonArrayEdits);
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("file=");
        builder.append(this.file + ", ");
        builder.append("fileStamp=");
        builder.append(this.fileStamp + ", ");
        builder.append("edits=");
        builder.append(StringUtils.join(this.edits, (String)", "));
        builder.append("]");
        return builder.toString();
    }
}

