/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.JsonUtilities;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.Element;

public class TypeHierarchyItem {
    public static final TypeHierarchyItem[] EMPTY_ARRAY = new TypeHierarchyItem[0];
    public static final List<TypeHierarchyItem> EMPTY_LIST = Lists.newArrayList();
    private final Element classElement;
    private final String displayName;
    private final Element memberElement;
    private final Integer superclass;
    private final int[] interfaces;
    private final int[] mixins;
    private final int[] subclasses;

    public TypeHierarchyItem(Element classElement, String displayName, Element memberElement, Integer superclass, int[] interfaces, int[] mixins, int[] subclasses) {
        this.classElement = classElement;
        this.displayName = displayName;
        this.memberElement = memberElement;
        this.superclass = superclass;
        this.interfaces = interfaces;
        this.mixins = mixins;
        this.subclasses = subclasses;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TypeHierarchyItem) {
            TypeHierarchyItem other = (TypeHierarchyItem)obj;
            return ObjectUtilities.equals(other.classElement, this.classElement) && ObjectUtilities.equals(other.displayName, this.displayName) && ObjectUtilities.equals(other.memberElement, this.memberElement) && ObjectUtilities.equals(other.superclass, this.superclass) && Arrays.equals(other.interfaces, this.interfaces) && Arrays.equals(other.mixins, this.mixins) && Arrays.equals(other.subclasses, this.subclasses);
        }
        return false;
    }

    public static TypeHierarchyItem fromJson(JsonObject jsonObject) {
        Element classElement = Element.fromJson(jsonObject.get("classElement").getAsJsonObject());
        String displayName = jsonObject.get("displayName") == null ? null : jsonObject.get("displayName").getAsString();
        Element memberElement = jsonObject.get("memberElement") == null ? null : Element.fromJson(jsonObject.get("memberElement").getAsJsonObject());
        Integer superclass = jsonObject.get("superclass") == null ? null : Integer.valueOf(jsonObject.get("superclass").getAsInt());
        int[] interfaces = JsonUtilities.decodeIntArray(jsonObject.get("interfaces").getAsJsonArray());
        int[] mixins = JsonUtilities.decodeIntArray(jsonObject.get("mixins").getAsJsonArray());
        int[] subclasses = JsonUtilities.decodeIntArray(jsonObject.get("subclasses").getAsJsonArray());
        return new TypeHierarchyItem(classElement, displayName, memberElement, superclass, interfaces, mixins, subclasses);
    }

    public static List<TypeHierarchyItem> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<TypeHierarchyItem> list = new ArrayList<TypeHierarchyItem>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(TypeHierarchyItem.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public String getBestName() {
        if (this.displayName == null) {
            return this.classElement.getName();
        }
        return this.displayName;
    }

    public Element getClassElement() {
        return this.classElement;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int[] getInterfaces() {
        return this.interfaces;
    }

    public Element getMemberElement() {
        return this.memberElement;
    }

    public int[] getMixins() {
        return this.mixins;
    }

    public int[] getSubclasses() {
        return this.subclasses;
    }

    public Integer getSuperclass() {
        return this.superclass;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.classElement);
        builder.append((Object)this.displayName);
        builder.append((Object)this.memberElement);
        builder.append((Object)this.superclass);
        builder.append(this.interfaces);
        builder.append(this.mixins);
        builder.append(this.subclasses);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("classElement", (JsonElement)this.classElement.toJson());
        if (this.displayName != null) {
            jsonObject.addProperty("displayName", this.displayName);
        }
        if (this.memberElement != null) {
            jsonObject.add("memberElement", (JsonElement)this.memberElement.toJson());
        }
        if (this.superclass != null) {
            jsonObject.addProperty("superclass", (Number)this.superclass);
        }
        JsonArray jsonArrayInterfaces = new JsonArray();
        for (int elt : this.interfaces) {
            jsonArrayInterfaces.add((JsonElement)new JsonPrimitive((Number)elt));
        }
        jsonObject.add("interfaces", (JsonElement)jsonArrayInterfaces);
        JsonArray jsonArrayMixins = new JsonArray();
        for (int elt : this.mixins) {
            jsonArrayMixins.add((JsonElement)new JsonPrimitive((Number)elt));
        }
        jsonObject.add("mixins", (JsonElement)jsonArrayMixins);
        JsonArray jsonArraySubclasses = new JsonArray();
        for (int elt : this.subclasses) {
            jsonArraySubclasses.add((JsonElement)new JsonPrimitive((Number)elt));
        }
        jsonObject.add("subclasses", (JsonElement)jsonArraySubclasses);
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("classElement=");
        builder.append(this.classElement + ", ");
        builder.append("displayName=");
        builder.append(this.displayName + ", ");
        builder.append("memberElement=");
        builder.append(this.memberElement + ", ");
        builder.append("superclass=");
        builder.append(this.superclass + ", ");
        builder.append("interfaces=");
        builder.append(StringUtils.join((Object[])new Serializable[]{this.interfaces, ", "}) + ", ");
        builder.append("mixins=");
        builder.append(StringUtils.join((Object[])new Serializable[]{this.mixins, ", "}) + ", ");
        builder.append("subclasses=");
        builder.append(StringUtils.join((Object[])new Serializable[]{this.subclasses, ", "}));
        builder.append("]");
        return builder.toString();
    }
}

