/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service.element;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.dartlang.vm.service.element.Element;
import org.dartlang.vm.service.element.Response;
import org.dartlang.vm.service.element.Sentinel;
import org.dartlang.vm.service.internal.VmServiceConst;

public class RPCError
extends Element
implements VmServiceConst {
    public static final int UNEXPECTED_RESPONSE = 5;

    public static RPCError unexpected(String expectedType, Response response) {
        String errMsg = "Expected type " + expectedType + " but received " + response.getType();
        if (response instanceof Sentinel) {
            errMsg = errMsg + ": " + (Object)((Object)((Sentinel)response).getKind());
        }
        JsonObject json = new JsonObject();
        json.addProperty("code", (Number)5);
        json.addProperty("message", errMsg);
        JsonObject data = new JsonObject();
        data.addProperty("details", errMsg);
        data.add("response", (JsonElement)response.getJson());
        json.add("data", (JsonElement)data);
        return new RPCError(json);
    }

    public RPCError(JsonObject json) {
        super(json);
    }

    public int getCode() {
        return this.json.get("code").getAsInt();
    }

    public String getDetails() {
        JsonElement details;
        JsonElement data = this.json.get("data");
        if (data instanceof JsonObject && (details = ((JsonObject)data).get("details")) != null) {
            return details.getAsString();
        }
        return null;
    }

    public String getMessage() {
        return this.json.get("message").getAsString();
    }

    public JsonObject getRequest() {
        JsonElement request;
        JsonElement data = this.json.get("data");
        if (data instanceof JsonObject && (request = ((JsonObject)data).get("request")) instanceof JsonObject) {
            return (JsonObject)request;
        }
        return null;
    }
}

