/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service.internal;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import org.dartlang.vm.service.internal.ErrorRequestSink;
import org.dartlang.vm.service.internal.RequestSink;
import org.dartlang.vm.service.internal.ResponseSink;

public class BlockingRequestSink
implements RequestSink {
    private final RequestSink base;
    private final LinkedList<JsonObject> queue = Lists.newLinkedList();

    public BlockingRequestSink(RequestSink base) {
        this.base = base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(JsonObject request) {
        LinkedList<JsonObject> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.add(request);
        }
    }

    @Override
    public void close() {
        this.base.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestSink toErrorSink(ResponseSink errorResponseSink, String errorResponseCode, String errorResponseMessage) {
        ErrorRequestSink errorRequestSink = new ErrorRequestSink(errorResponseSink, errorResponseCode, errorResponseMessage);
        LinkedList<JsonObject> linkedList = this.queue;
        synchronized (linkedList) {
            for (JsonObject request : this.queue) {
                errorRequestSink.add(request);
            }
        }
        return errorRequestSink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestSink toPassthroughSink() {
        LinkedList<JsonObject> linkedList = this.queue;
        synchronized (linkedList) {
            for (JsonObject request : this.queue) {
                this.base.add(request);
            }
        }
        return this.base;
    }
}

