/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.webcore.util.JsonUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaConfig {
    private static final Logger LOG = Logger.getInstance(KarmaConfig.class);
    private static final String AUTO_WATCH = "autoWatch";
    private static final String BASE_PATH = "basePath";
    private static final String BROWSERS = "browsers";
    private static final String HOST_NAME = "hostname";
    private static final String URL_ROOT = "urlRoot";
    private static final String WEBPACK = "webpack";
    private final boolean myAutoWatch;
    private final List<String> myBrowsers;
    private final String myBasePath;
    private final String myHostname;
    private final String myUrlRoot;
    private final boolean myWebpack;

    public KarmaConfig(boolean autoWatch, @NotNull String basePath, @NotNull List<String> browsers, @NotNull String hostname, @NotNull String urlRoot, boolean webpack) {
        if (basePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", BASE_PATH, "com/intellij/javascript/karma/KarmaConfig", "<init>"));
        }
        if (browsers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", BROWSERS, "com/intellij/javascript/karma/KarmaConfig", "<init>"));
        }
        if (hostname == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", HOST_NAME, "com/intellij/javascript/karma/KarmaConfig", "<init>"));
        }
        if (urlRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", URL_ROOT, "com/intellij/javascript/karma/KarmaConfig", "<init>"));
        }
        this.myAutoWatch = autoWatch;
        this.myBasePath = basePath;
        this.myBrowsers = ImmutableList.copyOf(browsers);
        this.myHostname = hostname;
        this.myUrlRoot = urlRoot;
        this.myWebpack = webpack;
    }

    public boolean isAutoWatch() {
        return this.myAutoWatch;
    }

    @NotNull
    public String getBasePath() {
        String string = this.myBasePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/KarmaConfig", "getBasePath"));
        }
        return string;
    }

    @NotNull
    public List<String> getBrowsers() {
        List<String> list = this.myBrowsers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/KarmaConfig", "getBrowsers"));
        }
        return list;
    }

    @NotNull
    public String getHostname() {
        String string = this.myHostname;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/KarmaConfig", "getHostname"));
        }
        return string;
    }

    @NotNull
    public String getUrlRoot() {
        String string = this.myUrlRoot;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/KarmaConfig", "getUrlRoot"));
        }
        return string;
    }

    public boolean isWebpack() {
        return this.myWebpack;
    }

    @Nullable
    public static KarmaConfig parseFromJson(@NotNull JsonElement jsonElement, @NotNull File configurationFileDir) {
        if (jsonElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonElement", "com/intellij/javascript/karma/KarmaConfig", "parseFromJson"));
        }
        if (configurationFileDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationFileDir", "com/intellij/javascript/karma/KarmaConfig", "parseFromJson"));
        }
        if (jsonElement.isJsonObject()) {
            JsonObject rootObject = jsonElement.getAsJsonObject();
            boolean autoWatch = JsonUtil.getChildAsBoolean((JsonObject)rootObject, (String)AUTO_WATCH, (boolean)false);
            List<String> browsers = KarmaConfig.parseBrowsers(rootObject);
            String basePath = KarmaConfig.parseBasePath(jsonElement, rootObject, configurationFileDir);
            String hostname = KarmaConfig.parseHostname(jsonElement, rootObject);
            String urlRoot = KarmaConfig.parseUrlRoot(jsonElement, rootObject);
            boolean webpack = JsonUtil.getChildAsBoolean((JsonObject)rootObject, (String)WEBPACK, (boolean)false);
            return new KarmaConfig(autoWatch, basePath, browsers, hostname, urlRoot, webpack);
        }
        return null;
    }

    @NotNull
    private static String parseBasePath(@NotNull JsonElement all, @NotNull JsonObject obj, @NotNull File configurationFileDir) {
        if (all == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "all", "com/intellij/javascript/karma/KarmaConfig", "parseBasePath"));
        }
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/javascript/karma/KarmaConfig", "parseBasePath"));
        }
        if (configurationFileDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationFileDir", "com/intellij/javascript/karma/KarmaConfig", "parseBasePath"));
        }
        String basePath = JsonUtil.getChildAsString((JsonObject)obj, (String)BASE_PATH);
        if (basePath == null) {
            LOG.warn("Can not parse Karma config.basePath from " + all.toString());
            basePath = configurationFileDir.getAbsolutePath();
        }
        String string = basePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/KarmaConfig", "parseBasePath"));
        }
        return string;
    }

    private static String parseUrlRoot(@NotNull JsonElement all, @NotNull JsonObject obj) {
        if (all == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "all", "com/intellij/javascript/karma/KarmaConfig", "parseUrlRoot"));
        }
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/javascript/karma/KarmaConfig", "parseUrlRoot"));
        }
        String urlRoot = JsonUtil.getChildAsString((JsonObject)obj, (String)URL_ROOT);
        if (urlRoot == null) {
            LOG.warn("Can not parse Karma config.urlRoot from " + all.toString());
            urlRoot = "/";
        }
        if (!urlRoot.startsWith("/")) {
            urlRoot = "/" + urlRoot;
        }
        if (urlRoot.length() > 1 && urlRoot.endsWith("/")) {
            urlRoot = urlRoot.substring(0, urlRoot.length() - 1);
        }
        return urlRoot;
    }

    private static String parseHostname(@NotNull JsonElement all, @NotNull JsonObject obj) {
        if (all == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "all", "com/intellij/javascript/karma/KarmaConfig", "parseHostname"));
        }
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/javascript/karma/KarmaConfig", "parseHostname"));
        }
        String hostname = JsonUtil.getChildAsString((JsonObject)obj, (String)HOST_NAME);
        if (hostname == null) {
            LOG.warn("Can not parse Karma config.hostname from " + all.toString());
            hostname = "localhost";
        }
        hostname = hostname.toLowerCase(Locale.ENGLISH);
        return hostname;
    }

    @NotNull
    private static List<String> parseBrowsers(@NotNull JsonObject obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/javascript/karma/KarmaConfig", "parseBrowsers"));
        }
        JsonElement browsersElement = obj.get(BROWSERS);
        if (browsersElement != null && browsersElement.isJsonArray()) {
            JsonArray browsersArray = browsersElement.getAsJsonArray();
            ArrayList browsers = Lists.newArrayList();
            for (JsonElement browserElement : browsersArray) {
                String browser = JsonUtil.getString((JsonElement)browserElement);
                if (browser == null) continue;
                browsers.add(browser);
            }
            ArrayList arrayList = browsers;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/KarmaConfig", "parseBrowsers"));
            }
            return arrayList;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/KarmaConfig", "parseBrowsers"));
        }
        return list;
    }
}

