/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.config;

import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaBasePathFinder {
    private static final String BASE_PATH_VAR_NAME = "basePath";
    private static final KarmaBasePathFinder INSTANCE = new KarmaBasePathFinder();
    private final Key<CachedValue<String>> myTestFileStructureRegistryKey = Key.create((String)KarmaBasePathFinder.class.getSimpleName());

    @NotNull
    public static KarmaBasePathFinder getInstance() {
        KarmaBasePathFinder karmaBasePathFinder = INSTANCE;
        if (karmaBasePathFinder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/config/KarmaBasePathFinder", "getInstance"));
        }
        return karmaBasePathFinder;
    }

    public String fetchBasePath(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFile", "com/intellij/javascript/karma/config/KarmaBasePathFinder", "fetchBasePath"));
        }
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)jsFile.getProject());
        return (String)cachedValuesManager.getCachedValue((UserDataHolder)jsFile, this.myTestFileStructureRegistryKey, () -> {
            if (jsFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFile", "com/intellij/javascript/karma/config/KarmaBasePathFinder", "lambda$fetchBasePath$0"));
            }
            String basePath = KarmaBasePathFinder.buildBasePath(jsFile);
            return CachedValueProvider.Result.create((Object)basePath, (Object[])new Object[]{jsFile});
        }, false);
    }

    @Nullable
    private static String buildBasePath(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFile", "com/intellij/javascript/karma/config/KarmaBasePathFinder", "buildBasePath"));
        }
        final Ref basePathRef = Ref.create(null);
        JSElementVisitor visitor = new JSElementVisitor(){

            public void visitJSProperty(JSProperty property) {
                JSLiteralExpression value;
                String name = JsPsiUtils.getPropertyName((JSProperty)property);
                if (KarmaBasePathFinder.BASE_PATH_VAR_NAME.equals(name) && (value = (JSLiteralExpression)ObjectUtils.tryCast((Object)property.getValue(), JSLiteralExpression.class)) != null && value.isQuotedLiteral()) {
                    basePathRef.set((Object)StringUtil.unquoteString((String)value.getText()));
                }
            }

            public void visitElement(PsiElement element) {
                ProgressIndicatorProvider.checkCanceled();
                if (basePathRef.isNull()) {
                    element.acceptChildren((PsiElementVisitor)this);
                }
            }
        };
        visitor.visitJSFile(jsFile);
        return (String)basePathRef.get();
    }

    public static boolean isBasePathStringLiteral(@NotNull JSLiteralExpression literalExpression) {
        JSProperty property;
        if (literalExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalExpression", "com/intellij/javascript/karma/config/KarmaBasePathFinder", "isBasePathStringLiteral"));
        }
        if (literalExpression.isQuotedLiteral() && (property = (JSProperty)ObjectUtils.tryCast((Object)literalExpression.getParent(), JSProperty.class)) != null) {
            String name = JsPsiUtils.getPropertyName((JSProperty)property);
            return BASE_PATH_VAR_NAME.equals(name);
        }
        return false;
    }
}

