/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.config;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javascript.karma.config.KarmaConfigFileReference;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaConfigFileInspection
extends JSInspection {
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSLiteralExpression(JSLiteralExpression node) {
                for (PsiReference ref : node.getReferences()) {
                    if (!(ref instanceof KarmaConfigFileReference)) continue;
                    KarmaConfigFileInspection.handleReference((KarmaConfigFileReference)ref, holder);
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/config/KarmaConfigFileInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private static void handleReference(@NotNull KarmaConfigFileReference ref, @NotNull ProblemsHolder holder) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/javascript/karma/config/KarmaConfigFileInspection", "handleReference"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/javascript/karma/config/KarmaConfigFileInspection", "handleReference"));
        }
        if (ref.isLast()) {
            PsiFileSystemItem fileItem = KarmaConfigFileInspection.resolve(ref);
            if (fileItem == null) {
                return;
            }
            KarmaConfigFileReference.FileType fileType = ref.getExpectedFileType();
            if (fileType == KarmaConfigFileReference.FileType.DIRECTORY && !fileItem.isDirectory()) {
                holder.registerProblemForReference((PsiReference)ref, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, "Directory expected", new LocalQuickFix[0]);
            }
            if (fileType == KarmaConfigFileReference.FileType.FILE && fileItem.isDirectory()) {
                holder.registerProblemForReference((PsiReference)ref, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, "File/Pattern expected", new LocalQuickFix[0]);
            }
        }
    }

    @Nullable
    private static PsiFileSystemItem resolve(@NotNull KarmaConfigFileReference ref) {
        ResolveResult[] results;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/javascript/karma/config/KarmaConfigFileInspection", "resolve"));
        }
        for (ResolveResult result : results = ref.multiResolve(false)) {
            PsiElement element;
            if (!result.isValidResult() || !((element = result.getElement()) instanceof PsiFileSystemItem)) continue;
            return (PsiFileSystemItem)element;
        }
        return null;
    }
}

