/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.config;

import com.intellij.javascript.karma.config.KarmaBasePathFinder;
import com.intellij.javascript.karma.config.KarmaConfigFileReference;
import com.intellij.javascript.karma.util.KarmaUtil;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class KarmaConfigReferenceContributor
extends PsiReferenceContributor {
    private static final String FILES_VAR_NAME = "files";
    public static final ElementPattern<JSLiteralExpression> STRING_LITERAL_INSIDE_KARMA_CONFIG_FILE = PlatformPatterns.psiElement(JSLiteralExpression.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

        public boolean isAcceptable(Object element, PsiElement context) {
            PsiFile psiFile = context.getContainingFile();
            return KarmaUtil.isKarmaConfigFile(psiFile.getName(), false);
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    }));

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/javascript/karma/config/KarmaConfigReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider(STRING_LITERAL_INSIDE_KARMA_CONFIG_FILE, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/javascript/karma/config/KarmaConfigReferenceContributor$2", "getReferencesByElement"));
                }
                if (processingContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "com/intellij/javascript/karma/config/KarmaConfigReferenceContributor$2", "getReferencesByElement"));
                }
                JSLiteralExpression literalExpression = (JSLiteralExpression)ObjectUtils.tryCast((Object)psiElement, JSLiteralExpression.class);
                if (literalExpression == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/config/KarmaConfigReferenceContributor$2", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                if (KarmaBasePathFinder.isBasePathStringLiteral(literalExpression)) {
                    FileReference[] fileReferenceArray = new BasePathFileReferenceSet(literalExpression, this).getAllReferences();
                    if (fileReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/config/KarmaConfigReferenceContributor$2", "getReferencesByElement"));
                    }
                    return fileReferenceArray;
                }
                if (KarmaConfigReferenceContributor.isFileStringLiteral(literalExpression)) {
                    FileReference[] fileReferenceArray = new FilesFileReferenceSet(literalExpression, this).getAllReferences();
                    if (fileReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/config/KarmaConfigReferenceContributor$2", "getReferencesByElement"));
                    }
                    return fileReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/config/KarmaConfigReferenceContributor$2", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
        });
    }

    private static boolean isFileStringLiteral(@NotNull JSLiteralExpression literalExpression) {
        JSProperty property;
        JSArrayLiteralExpression arrayLiteralExpression;
        if (literalExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalExpression", "com/intellij/javascript/karma/config/KarmaConfigReferenceContributor", "isFileStringLiteral"));
        }
        if (literalExpression.isQuotedLiteral() && (arrayLiteralExpression = (JSArrayLiteralExpression)ObjectUtils.tryCast((Object)literalExpression.getParent(), JSArrayLiteralExpression.class)) != null && (property = (JSProperty)ObjectUtils.tryCast((Object)arrayLiteralExpression.getParent(), JSProperty.class)) != null) {
            String name = JsPsiUtils.getPropertyName((JSProperty)property);
            return FILES_VAR_NAME.equals(name);
        }
        return false;
    }

    private static class FilesFileReferenceSet
    extends FileReferenceSet {
        private boolean myPatternUsed;

        public FilesFileReferenceSet(@NotNull JSLiteralExpression literalExpression, @NotNull PsiReferenceProvider psiReferenceProvider) {
            if (literalExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalExpression", "com/intellij/javascript/karma/config/KarmaConfigReferenceContributor$FilesFileReferenceSet", "<init>"));
            }
            if (psiReferenceProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiReferenceProvider", "com/intellij/javascript/karma/config/KarmaConfigReferenceContributor$FilesFileReferenceSet", "<init>"));
            }
            super(StringUtil.unquoteString((String)literalExpression.getText()), (PsiElement)literalExpression, 1, psiReferenceProvider, !SystemInfo.isWindows, false, null, false);
            this.myPatternUsed = false;
            this.setEmptyPathAllowed(true);
            super.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, file -> {
                PsiDirectory psiChildDirectory;
                if (!(file instanceof JSFile)) {
                    return null;
                }
                PsiDirectory psiDirectory = file.getParent();
                if (psiDirectory == null) {
                    return null;
                }
                String basePath = KarmaBasePathFinder.getInstance().fetchBasePath((JSFile)file);
                if (StringUtil.isEmpty((String)basePath)) {
                    return Collections.singletonList(psiDirectory);
                }
                VirtualFile vDirectory = psiDirectory.getVirtualFile();
                VirtualFile vChildDirectory = vDirectory.findFileByRelativePath(basePath);
                if (vChildDirectory != null && (psiChildDirectory = psiDirectory.getManager().findDirectory(vChildDirectory)) != null) {
                    return Collections.singletonList(psiChildDirectory);
                }
                return Collections.emptyList();
            });
            super.reparse();
        }

        @NotNull
        public Collection<PsiFileSystemItem> computeDefaultContexts() {
            if (this.isAbsolutePathReference()) {
                Collection collection = this.toFileSystemItems(ManagingFS.getInstance().getLocalRoots());
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/config/KarmaConfigReferenceContributor$FilesFileReferenceSet", "computeDefaultContexts"));
                }
                return collection;
            }
            Collection collection = super.computeDefaultContexts();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/config/KarmaConfigReferenceContributor$FilesFileReferenceSet", "computeDefaultContexts"));
            }
            return collection;
        }

        public FileReference createFileReference(TextRange range, int index, String text) {
            if (!this.myPatternUsed && text.contains("*")) {
                this.myPatternUsed = true;
            }
            return new KarmaConfigFileReference(this, range, index, text, KarmaConfigFileReference.FileType.FILE, this.myPatternUsed);
        }

        protected boolean isSoft() {
            return true;
        }
    }

    private static class BasePathFileReferenceSet
    extends FileReferenceSet {
        public BasePathFileReferenceSet(@NotNull JSLiteralExpression literalExpression, @NotNull PsiReferenceProvider psiReferenceProvider) {
            if (literalExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalExpression", "com/intellij/javascript/karma/config/KarmaConfigReferenceContributor$BasePathFileReferenceSet", "<init>"));
            }
            if (psiReferenceProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiReferenceProvider", "com/intellij/javascript/karma/config/KarmaConfigReferenceContributor$BasePathFileReferenceSet", "<init>"));
            }
            super(BasePathFileReferenceSet.getString(literalExpression), (PsiElement)literalExpression, 1, psiReferenceProvider, !SystemInfo.isWindows, false, null, false);
            this.setEmptyPathAllowed(true);
            super.reparse();
        }

        private static String getString(@NotNull JSLiteralExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/javascript/karma/config/KarmaConfigReferenceContributor$BasePathFileReferenceSet", "getString"));
            }
            String value = StringUtil.unquoteString((String)expression.getText());
            return value.isEmpty() ? "." : value;
        }

        @NotNull
        public Collection<PsiFileSystemItem> computeDefaultContexts() {
            if (this.isAbsolutePathReference()) {
                Collection collection = this.toFileSystemItems(ManagingFS.getInstance().getLocalRoots());
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/config/KarmaConfigReferenceContributor$BasePathFileReferenceSet", "computeDefaultContexts"));
                }
                return collection;
            }
            Collection collection = super.computeDefaultContexts();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/config/KarmaConfigReferenceContributor$BasePathFileReferenceSet", "computeDefaultContexts"));
            }
            return collection;
        }

        protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
            return FileReferenceSet.DIRECTORY_FILTER;
        }

        public FileReference createFileReference(TextRange range, int index, String text) {
            return new KarmaConfigFileReference(this, range, index, text, KarmaConfigFileReference.FileType.DIRECTORY, false);
        }

        protected boolean isSoft() {
            return true;
        }
    }
}

