/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.coverage;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.karma.coverage.KarmaCoverageStartupStatus;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.server.KarmaServerLogComponent;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaCoverageConfigurationErrorConsole
implements ExecutionConsoleEx {
    private static final String TITLE = "<div style='padding-bottom:4px;'><strong>Sorry, looks like we can't measure code coverage!</strong></div>";
    private static final String SEE_KARMA_SERVER_TAB = "<div style='padding-top:3px;'>See 'Karma Server' tab for details.</div>";
    private final Project myProject;
    private final KarmaServer myServer;
    private final KarmaCoverageStartupStatus myStatus;
    private JComponent myComponent;

    public KarmaCoverageConfigurationErrorConsole(@NotNull Project project, @NotNull KarmaServer server, @Nullable KarmaCoverageStartupStatus status) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/coverage/KarmaCoverageConfigurationErrorConsole", "<init>"));
        }
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javascript/karma/coverage/KarmaCoverageConfigurationErrorConsole", "<init>"));
        }
        this.myProject = project;
        this.myServer = server;
        this.myStatus = status;
    }

    public void buildUi(RunnerLayoutUi ui) {
        this.registerTestRunTab(ui);
        KarmaServerLogComponent.register(this.myProject, this.myServer, ui, this.myStatus == null);
    }

    private void registerTestRunTab(@NotNull RunnerLayoutUi ui) {
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/javascript/karma/coverage/KarmaCoverageConfigurationErrorConsole", "registerTestRunTab"));
        }
        ui.getOptions().setMinimizeActionEnabled(false);
        Content consoleContent = ui.createContent("ConsoleContent", this.getComponent(), this.myStatus != null ? "Coverage Configuration Error" : "Test Run", AllIcons.Debugger.Console, this.getPreferredFocusableComponent());
        ui.addContent(consoleContent, 1, PlaceInGrid.bottom, false);
        consoleContent.setCloseable(false);
        ui.selectAndFocus(consoleContent, false, false);
    }

    @Nullable
    public String getExecutionConsoleId() {
        return null;
    }

    public JComponent getComponent() {
        if (this.myComponent == null) {
            JEditorPane pane = this.createEditorPane();
            pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.myComponent = ScrollPaneFactory.createScrollPane((Component)pane, (int)20, (int)30);
        }
        return this.myComponent;
    }

    @NotNull
    private JEditorPane createEditorPane() {
        EditorColorsScheme colorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Font font = colorsScheme.getFont(EditorFontType.PLAIN);
        Color background = colorsScheme.getDefaultBackground();
        Color foreground = KarmaCoverageConfigurationErrorConsole.getTextForeground(colorsScheme);
        JEditorPane jEditorPane = ComponentsKt.htmlComponent((String)this.getWarningMessage(), (Font)font, (Color)background, (Color)foreground);
        if (jEditorPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoverageConfigurationErrorConsole", "createEditorPane"));
        }
        return jEditorPane;
    }

    @NotNull
    private static Color getTextForeground(@NotNull EditorColorsScheme colorsScheme) {
        if (colorsScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsScheme", "com/intellij/javascript/karma/coverage/KarmaCoverageConfigurationErrorConsole", "getTextForeground"));
        }
        TextAttributes textAttributes = colorsScheme.getAttributes(ConsoleViewContentType.ERROR_OUTPUT_KEY);
        if (textAttributes != null && textAttributes.getForegroundColor() != null) {
            Color color = textAttributes.getForegroundColor();
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoverageConfigurationErrorConsole", "getTextForeground"));
            }
            return color;
        }
        Color color = UIUtil.getLabelForeground();
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoverageConfigurationErrorConsole", "getTextForeground"));
        }
        return color;
    }

    @NotNull
    private String getWarningMessage() {
        if (this.myStatus == null) {
            String string = KarmaCoverageConfigurationErrorConsole.getCommonWarning();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoverageConfigurationErrorConsole", "getWarningMessage"));
            }
            return string;
        }
        if (!this.myStatus.isCoveragePreprocessorSpecifiedInConfig()) {
            String string = KarmaCoverageConfigurationErrorConsole.getWarningAboutMissingCoveragePreprocessorInConfigFile();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoverageConfigurationErrorConsole", "getWarningMessage"));
            }
            return string;
        }
        if (!this.myStatus.isCoverageReportFound()) {
            if (this.myStatus.isKarmaCoveragePackageNeededToBeInstalled()) {
                String string = this.getSuggestionAboutCoveragePluginInstallation();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoverageConfigurationErrorConsole", "getWarningMessage"));
                }
                return string;
            }
            String string = KarmaCoverageConfigurationErrorConsole.getWarningAboutMissingCoveragePluginInConfigFile();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoverageConfigurationErrorConsole", "getWarningMessage"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoverageConfigurationErrorConsole", "getWarningMessage"));
        }
        return "";
    }

    @NotNull
    private static String getCommonWarning() {
        if ("<div style='padding-bottom:4px;'><strong>Sorry, looks like we can't measure code coverage!</strong></div><div style='padding-top:3px;'>See 'Karma Server' tab for details.</div>" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoverageConfigurationErrorConsole", "getCommonWarning"));
        }
        return "<div style='padding-bottom:4px;'><strong>Sorry, looks like we can't measure code coverage!</strong></div><div style='padding-top:3px;'>See 'Karma Server' tab for details.</div>";
    }

    @NotNull
    private static Color getCodeBackground() {
        TextAttributesKey[] keys = UIUtil.isUnderDarcula() ? new TextAttributesKey[]{CodeInsightColors.FOLLOWED_HYPERLINK_ATTRIBUTES} : new TextAttributesKey[]{EditorColors.DELETED_TEXT_ATTRIBUTES, CodeInsightColors.FOLLOWED_HYPERLINK_ATTRIBUTES};
        EditorColorsScheme colorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        for (TextAttributesKey key : keys) {
            TextAttributes textAttributes = colorsScheme.getAttributes(key);
            if (textAttributes == null || textAttributes.getBackgroundColor() == null) continue;
            Color color = textAttributes.getBackgroundColor();
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoverageConfigurationErrorConsole", "getCodeBackground"));
            }
            return color;
        }
        Color color = UIUtil.getOptionPaneBackground();
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoverageConfigurationErrorConsole", "getCodeBackground"));
        }
        return color;
    }

    private static String formatHtmlCode(@NotNull String[] lines) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/javascript/karma/coverage/KarmaCoverageConfigurationErrorConsole", "formatHtmlCode"));
        }
        Color background = KarmaCoverageConfigurationErrorConsole.getCodeBackground();
        StringBuilder colorBuf = new StringBuilder();
        UIUtil.appendColor((Color)background, (StringBuilder)colorBuf);
        return "<div style='padding-left:10px; padding-top:5px; padding-bottom:5px;'><table cellspacing='0' cellpadding='0' style='border: none;'><tr><td><div style='padding-left:6px; padding-top:2px; padding-bottom:2px; padding-right:6px; background-color:#" + colorBuf.toString() + ";'><pre><code>" + StringUtil.join((String[])lines, (String)"\n") + "</code></pre></div></td><td></td></tr></table></div>";
    }

    @NotNull
    private static String getWarningAboutMissingCoveragePreprocessorInConfigFile() {
        String string = "<div style='padding-bottom:4px;'><strong>Sorry, looks like we can't measure code coverage!</strong></div><div style='padding-top:3px'>Make sure coverage preprocessor is configured like this:</div>" + KarmaCoverageConfigurationErrorConsole.formatHtmlCode(new String[]{"module.exports = function (config) {", "  config.set({", "    ...", "    preprocessors: {", "      // source files, that you wanna generate coverage for", "      // do not include tests or libraries", "      // (these files will be instrumented by Istanbul)", "      'src/*.js': ['coverage']", "    },", "    ...", "  });", "};"}) + "As the preprocessor is configured, run with coverage again.";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoverageConfigurationErrorConsole", "getWarningAboutMissingCoveragePreprocessorInConfigFile"));
        }
        return string;
    }

    @NotNull
    private String getSuggestionAboutCoveragePluginInstallation() {
        File karmaPackageDir = this.myServer.getKarmaPackageDir();
        File nodeModulesDir = karmaPackageDir.getParentFile();
        String path = "node_modules".equals(nodeModulesDir.getName()) ? nodeModulesDir.getAbsolutePath() : karmaPackageDir.getAbsolutePath();
        String string = "<div style='padding-bottom:4px;'><strong>Sorry, looks like we can't measure code coverage!</strong></div><div style='padding-top:3px;'>See 'Karma Server' tab for details.</div><div style='padding-top:3px'>It seems that 'karma-coverage' node package isn't installed.</div><div style='padding-top:3px'>To install it execute the following commands:</div>" + KarmaCoverageConfigurationErrorConsole.formatHtmlCode(new String[]{"cd " + path, "npm install karma-coverage"}) + "As the package is installed, run with coverage again.";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoverageConfigurationErrorConsole", "getSuggestionAboutCoveragePluginInstallation"));
        }
        return string;
    }

    @NotNull
    private static String getWarningAboutMissingCoveragePluginInConfigFile() {
        String string = "<div style='padding-bottom:4px;'><strong>Sorry, looks like we can't measure code coverage!</strong></div><div style='padding-top:3px;'>See 'Karma Server' tab for details.</div><div style='padding-top:3px'>It seems that <code>'coverage'</code> reporter isn't available.</div><div style='padding-top:3px; padding-bottom:3px'>Make sure <code>'karma-coverage'</code> plugin is specified like this:</div>" + KarmaCoverageConfigurationErrorConsole.formatHtmlCode(new String[]{"module.exports = function (config) {", "  config.set({", "    ...", "    plugins: [..., 'karma-coverage'],", "    ...", "  });", "};"}) + "As the plugin is specified, run with coverage again.";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoverageConfigurationErrorConsole", "getWarningAboutMissingCoveragePluginInConfigFile"));
        }
        return string;
    }

    public JComponent getPreferredFocusableComponent() {
        return null;
    }

    public void dispose() {
    }
}

