/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.coverage;

import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageListRootNode;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.DirectoryCoverageViewExtension;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.javascript.karma.coverage.KarmaCoverageAnnotator;
import com.intellij.javascript.karma.coverage.KarmaCoverageEnabledConfiguration;
import com.intellij.javascript.karma.coverage.KarmaCoverageSuite;
import com.intellij.javascript.karma.execution.KarmaRunConfiguration;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.rt.coverage.data.ProjectData;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaCoverageEngine
extends CoverageEngine {
    public static final String ID = "KarmaJavaScriptTestRunnerCoverage";

    public boolean isApplicableTo(@Nullable RunConfigurationBase configuration) {
        return configuration instanceof KarmaRunConfiguration;
    }

    public boolean canHavePerTestCoverage(@Nullable RunConfigurationBase configuration) {
        return false;
    }

    @NotNull
    public CoverageEnabledConfiguration createCoverageEnabledConfiguration(@Nullable RunConfigurationBase configuration) {
        KarmaCoverageEnabledConfiguration karmaCoverageEnabledConfiguration = new KarmaCoverageEnabledConfiguration((KarmaRunConfiguration)configuration);
        if (karmaCoverageEnabledConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "createCoverageEnabledConfiguration"));
        }
        return karmaCoverageEnabledConfiguration;
    }

    /*
     * WARNING - void declaration
     */
    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, @Nullable String[] filters, long lastCoverageTimeStamp, @Nullable String suiteToMerge, boolean coverageByTestEnabled, boolean tracingEnabled, boolean trackTestFolders, Project project) {
        void project2;
        if (covRunner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "covRunner", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "createCoverageSuite"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "createCoverageSuite"));
        }
        if (coverageDataFileProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coverageDataFileProvider", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "createCoverageSuite"));
        }
        return new KarmaCoverageSuite(covRunner, name, coverageDataFileProvider, lastCoverageTimeStamp, coverageByTestEnabled, tracingEnabled, trackTestFolders, (Project)project2, this);
    }

    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, @NotNull CoverageEnabledConfiguration config) {
        if (covRunner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "covRunner", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "createCoverageSuite"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "createCoverageSuite"));
        }
        if (coverageDataFileProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coverageDataFileProvider", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "createCoverageSuite"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "createCoverageSuite"));
        }
        if (config instanceof KarmaCoverageEnabledConfiguration) {
            Project project = config.getConfiguration().getProject();
            return this.createCoverageSuite(covRunner, name, coverageDataFileProvider, null, new Date().getTime(), null, false, false, true, project);
        }
        return null;
    }

    public CoverageSuite createEmptyCoverageSuite(@NotNull CoverageRunner coverageRunner) {
        if (coverageRunner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coverageRunner", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "createEmptyCoverageSuite"));
        }
        return new KarmaCoverageSuite(this);
    }

    @NotNull
    public CoverageAnnotator getCoverageAnnotator(Project project) {
        KarmaCoverageAnnotator karmaCoverageAnnotator = KarmaCoverageAnnotator.getInstance(project);
        if (karmaCoverageAnnotator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "getCoverageAnnotator"));
        }
        return karmaCoverageAnnotator;
    }

    public boolean coverageEditorHighlightingApplicableTo(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "coverageEditorHighlightingApplicableTo"));
        }
        return psiFile instanceof JSFile;
    }

    public boolean acceptedByFilters(@NotNull PsiFile psiFile, @NotNull CoverageSuitesBundle suite) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "acceptedByFilters"));
        }
        if (suite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suite", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "acceptedByFilters"));
        }
        return true;
    }

    public boolean recompileProjectAndRerunAction(@NotNull Module module, @NotNull CoverageSuitesBundle suite, @NotNull Runnable chooseSuiteAction) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "recompileProjectAndRerunAction"));
        }
        if (suite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suite", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "recompileProjectAndRerunAction"));
        }
        if (chooseSuiteAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chooseSuiteAction", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "recompileProjectAndRerunAction"));
        }
        return false;
    }

    public String getQualifiedName(@NotNull File outputFile, @NotNull PsiFile sourceFile) {
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "getQualifiedName"));
        }
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "getQualifiedName"));
        }
        return KarmaCoverageEngine.getQName(sourceFile);
    }

    @Nullable
    private static String getQName(@NotNull PsiFile sourceFile) {
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "getQName"));
        }
        VirtualFile file = sourceFile.getVirtualFile();
        if (file == null) {
            return null;
        }
        return file.getPath();
    }

    @NotNull
    public Set<String> getQualifiedNames(@NotNull PsiFile sourceFile) {
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "getQualifiedNames"));
        }
        String qName = KarmaCoverageEngine.getQName(sourceFile);
        Set<String> set = qName != null ? Collections.singleton(qName) : Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "getQualifiedNames"));
        }
        return set;
    }

    public boolean includeUntouchedFileInCoverage(@NotNull String qualifiedName, @NotNull File outputFile, @NotNull PsiFile sourceFile, @NotNull CoverageSuitesBundle suite) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "includeUntouchedFileInCoverage"));
        }
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "includeUntouchedFileInCoverage"));
        }
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "includeUntouchedFileInCoverage"));
        }
        if (suite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suite", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "includeUntouchedFileInCoverage"));
        }
        return false;
    }

    public boolean isReportGenerationAvailable(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "isReportGenerationAvailable"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "isReportGenerationAvailable"));
        }
        if (currentSuite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSuite", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "isReportGenerationAvailable"));
        }
        return false;
    }

    public void generateReport(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuiteBundle) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "generateReport"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "generateReport"));
        }
        if (currentSuiteBundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSuiteBundle", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "generateReport"));
        }
    }

    public List<Integer> collectSrcLinesForUntouchedFile(@NotNull File classFile, @NotNull CoverageSuitesBundle suite) {
        if (classFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classFile", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "collectSrcLinesForUntouchedFile"));
        }
        if (suite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suite", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "collectSrcLinesForUntouchedFile"));
        }
        return null;
    }

    public List<PsiElement> findTestsByNames(@NotNull String[] testNames, @NotNull Project project) {
        if (testNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testNames", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "findTestsByNames"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "findTestsByNames"));
        }
        return Collections.emptyList();
    }

    public String getTestMethodName(@NotNull PsiElement element, @NotNull AbstractTestProxy testProxy) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "getTestMethodName"));
        }
        if (testProxy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testProxy", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "getTestMethodName"));
        }
        return null;
    }

    public String getPresentableText() {
        return ID;
    }

    public boolean coverageProjectViewStatisticsApplicableTo(VirtualFile fileOrDir) {
        return !fileOrDir.isDirectory();
    }

    public CoverageViewExtension createCoverageViewExtension(final Project project, final CoverageSuitesBundle suiteBundle, CoverageViewManager.StateBean stateBean) {
        return new DirectoryCoverageViewExtension(project, this.getCoverageAnnotator(project), suiteBundle, stateBean){

            public AbstractTreeNode createRootNode() {
                VirtualFile rootDir = KarmaCoverageEngine.findRootDir(project, suiteBundle);
                if (rootDir == null) {
                    rootDir = this.myProject.getBaseDir();
                }
                PsiDirectory psiRootDir = PsiManager.getInstance((Project)this.myProject).findDirectory(rootDir);
                return new CoverageListRootNode(this.myProject, (PsiNamedElement)psiRootDir, this.mySuitesBundle, this.myStateBean);
            }
        };
    }

    @Nullable
    private static VirtualFile findRootDir(final @NotNull Project project, final @NotNull CoverageSuitesBundle suitesBundle) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "findRootDir"));
        }
        if (suitesBundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suitesBundle", "com/intellij/javascript/karma/coverage/KarmaCoverageEngine", "findRootDir"));
        }
        return (VirtualFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                CoverageDataManager coverageDataManager = CoverageDataManager.getInstance((Project)project);
                for (CoverageSuite suite : suitesBundle.getSuites()) {
                    ProjectData data = suite.getCoverageData(coverageDataManager);
                    if (data == null) continue;
                    for (Object key : data.getClasses().keySet()) {
                        ProjectFileIndex projectFileIndex;
                        VirtualFile contentRoot;
                        String path;
                        VirtualFile file;
                        if (!(key instanceof String) || (file = VfsUtil.findFileByIoFile((File)new File(path = (String)key), (boolean)false)) == null || !file.isValid() || (contentRoot = (projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project)).getContentRootForFile(file)) == null || !contentRoot.isDirectory() || !contentRoot.isValid()) continue;
                        return contentRoot;
                    }
                }
                return null;
            }
        });
    }
}

