/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.coverage;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.javascript.karma.coverage.KarmaCoverageInitializationCallback;
import com.intellij.javascript.karma.coverage.KarmaCoverageSession;
import com.intellij.javascript.karma.coverage.KarmaCoverageStartupStatus;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.server.StreamEventHandler;
import com.intellij.javascript.karma.util.GsonUtil;
import com.intellij.javascript.karma.util.NodeInstalledPackage;
import com.intellij.javascript.karma.util.NodeInstalledPackagesLocator;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaCoveragePeer {
    private static final Logger LOG = Logger.getInstance(KarmaCoveragePeer.class);
    private final File myCoverageTempDir;
    private volatile KarmaCoverageSession myActiveCoverageSession;
    private KarmaCoverageStartupStatus myStartupStatus;
    private List<KarmaCoverageInitializationCallback> myListeners = Lists.newCopyOnWriteArrayList();
    private volatile boolean myDisposed = false;

    public KarmaCoveragePeer() throws IOException {
        this.myCoverageTempDir = FileUtil.createTempDirectory((String)"karma-intellij-coverage-", null);
    }

    @NotNull
    public File getCoverageTempDir() {
        File file = this.myCoverageTempDir;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoveragePeer", "getCoverageTempDir"));
        }
        return file;
    }

    public void startCoverageSession(@NotNull KarmaCoverageSession coverageSession) {
        if (coverageSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coverageSession", "com/intellij/javascript/karma/coverage/KarmaCoveragePeer", "startCoverageSession"));
        }
        if (this.myCoverageTempDir.isDirectory()) {
            File[] children;
            for (File child : children = (File[])ObjectUtils.notNull((Object)this.myCoverageTempDir.listFiles(), (Object)ArrayUtil.EMPTY_FILE_ARRAY)) {
                FileUtil.delete((File)child);
            }
        } else {
            FileUtil.createDirectory((File)this.myCoverageTempDir);
        }
        this.myActiveCoverageSession = coverageSession;
    }

    @Nullable
    public KarmaCoverageStartupStatus getStartupStatus() {
        return this.myStartupStatus;
    }

    public void dispose() {
        this.myDisposed = true;
    }

    public void onCoverageInitialized(@NotNull KarmaCoverageInitializationCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/javascript/karma/coverage/KarmaCoveragePeer", "onCoverageInitialized"));
        }
        if (this.myStartupStatus != null) {
            callback.onCoverageInitialized(this.myStartupStatus);
        } else {
            int timeoutMillis = 10000;
            Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
            alarm.addRequest(() -> {
                if (this.myStartupStatus == null) {
                    if (this.myDisposed) {
                        LOG.info("Karma coverage was already disposed");
                    } else {
                        LOG.error("Karma coverage hasn't been initialized in 10000 ms");
                        this.myListeners.clear();
                    }
                }
                Disposer.dispose((Disposable)alarm);
            }, 10000, ModalityState.any());
            this.myListeners.add(callback);
        }
    }

    private void fireOnCoverageInitialized(@NotNull KarmaCoverageStartupStatus startupStatus) {
        if (startupStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startupStatus", "com/intellij/javascript/karma/coverage/KarmaCoveragePeer", "fireOnCoverageInitialized"));
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (startupStatus == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startupStatus", "com/intellij/javascript/karma/coverage/KarmaCoveragePeer", "lambda$fireOnCoverageInitialized$1"));
            }
            this.myStartupStatus = startupStatus;
            for (KarmaCoverageInitializationCallback listener : this.myListeners) {
                listener.onCoverageInitialized(startupStatus);
            }
            this.myListeners.clear();
        });
    }

    private void onCoverageInitialized(@NotNull KarmaServer server, boolean coveragePreprocessorSpecifiedInConfig, boolean coverageReporterFound) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javascript/karma/coverage/KarmaCoveragePeer", "onCoverageInitialized"));
        }
        if (!coveragePreprocessorSpecifiedInConfig || coverageReporterFound) {
            this.fireOnCoverageInitialized(new KarmaCoverageStartupStatus(coveragePreprocessorSpecifiedInConfig, coverageReporterFound, true));
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (server == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javascript/karma/coverage/KarmaCoveragePeer", "lambda$onCoverageInitialized$3"));
                }
                ApplicationManager.getApplication().runReadAction(() -> {
                    if (server == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javascript/karma/coverage/KarmaCoveragePeer", "lambda$null$2"));
                    }
                    this.checkCoveragePlugin(server);
                });
            });
        }
    }

    private void checkCoveragePlugin(@NotNull KarmaServer server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javascript/karma/coverage/KarmaCoveragePeer", "checkCoveragePlugin"));
        }
        NodeInstalledPackagesLocator locator = NodeInstalledPackagesLocator.getInstance();
        NodeSettings nodeSettings = NodeSettings.create((NodeJsLocalInterpreter)server.getNodeInterpreter());
        NodeInstalledPackage pkg = locator.findInstalledPackages("karma-coverage", server.getKarmaPackageDir(), nodeSettings);
        this.fireOnCoverageInitialized(new KarmaCoverageStartupStatus(true, false, pkg != null));
    }

    public void registerEventHandlers(final @NotNull KarmaServer server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javascript/karma/coverage/KarmaCoveragePeer", "registerEventHandlers"));
        }
        server.registerStreamEventHandler(new StreamEventHandler(){

            @Override
            @NotNull
            public String getEventType() {
                if ("coverageFinished" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoveragePeer$1", "getEventType"));
                }
                return "coverageFinished";
            }

            @Override
            public void handle(@NotNull JsonElement eventBody) {
                String path;
                if (eventBody == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventBody", "com/intellij/javascript/karma/coverage/KarmaCoveragePeer$1", "handle"));
                }
                KarmaCoverageSession coverageSession = KarmaCoveragePeer.this.myActiveCoverageSession;
                KarmaCoveragePeer.this.myActiveCoverageSession = null;
                if (coverageSession != null && (path = JsonUtil.getString((JsonElement)eventBody)) != null) {
                    coverageSession.onCoverageSessionFinished(new File(path));
                }
            }
        });
        server.registerStreamEventHandler(new StreamEventHandler(){
            private AtomicBoolean myCoverageInitialized = new AtomicBoolean(true);
            private static final String COVERAGE_PREPROCESSOR_SPECIFIED_IN_CONFIG = "coveragePreprocessorSpecifiedInConfig";
            private static final String COVERAGE_REPORTER_FOUND = "coverageReporterFound";

            @Override
            @NotNull
            public String getEventType() {
                if ("coverageStartupStatus" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoveragePeer$2", "getEventType"));
                }
                return "coverageStartupStatus";
            }

            @Override
            public void handle(@NotNull JsonElement eventBody) {
                if (eventBody == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventBody", "com/intellij/javascript/karma/coverage/KarmaCoveragePeer$2", "handle"));
                }
                if (this.myCoverageInitialized.compareAndSet(true, false)) {
                    Boolean coverageReporterFound = null;
                    Boolean coveragePreprocessorSpecifiedInConfig = null;
                    if (eventBody.isJsonObject()) {
                        JsonObject eventObj = eventBody.getAsJsonObject();
                        coveragePreprocessorSpecifiedInConfig = GsonUtil.getBooleanProperty(eventObj, COVERAGE_PREPROCESSOR_SPECIFIED_IN_CONFIG);
                        coverageReporterFound = GsonUtil.getBooleanProperty(eventObj, COVERAGE_REPORTER_FOUND);
                    }
                    if (coveragePreprocessorSpecifiedInConfig == null) {
                        this.warnAboutMissingProperty(COVERAGE_PREPROCESSOR_SPECIFIED_IN_CONFIG);
                        coveragePreprocessorSpecifiedInConfig = true;
                    }
                    if (coverageReporterFound == null) {
                        this.warnAboutMissingProperty(COVERAGE_REPORTER_FOUND);
                        coverageReporterFound = true;
                    }
                    KarmaCoveragePeer.this.onCoverageInitialized(server, coveragePreprocessorSpecifiedInConfig, coverageReporterFound);
                }
            }

            private void warnAboutMissingProperty(@NotNull String propertyName) {
                if (propertyName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/javascript/karma/coverage/KarmaCoveragePeer$2", "warnAboutMissingProperty"));
                }
                LOG.warn("Malformed event '" + this.getEventType() + "': can not found boolean property '" + propertyName + "'!");
            }
        });
    }
}

