/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageHelper;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.process.NopProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.javascript.karma.coverage.KarmaCoverageConfigurationErrorConsole;
import com.intellij.javascript.karma.coverage.KarmaCoverageInitializationCallback;
import com.intellij.javascript.karma.coverage.KarmaCoveragePeer;
import com.intellij.javascript.karma.coverage.KarmaCoverageRunner;
import com.intellij.javascript.karma.coverage.KarmaCoverageSession;
import com.intellij.javascript.karma.coverage.KarmaCoverageStartupStatus;
import com.intellij.javascript.karma.execution.KarmaRunConfiguration;
import com.intellij.javascript.karma.execution.KarmaRunProfileState;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaCoverageProgramRunner
extends GenericProgramRunner {
    private static final Logger LOG = Logger.getInstance(KarmaCoverageProgramRunner.class);
    private static final String COVERAGE_RUNNER_ID = KarmaCoverageProgramRunner.class.getSimpleName();

    @NotNull
    public String getRunnerId() {
        String string = COVERAGE_RUNNER_ID;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner", "getRunnerId"));
        }
        return string;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner", "canRun"));
        }
        return "Coverage".equals(executorId) && profile instanceof KarmaRunConfiguration;
    }

    public RunnerSettings createConfigurationData(ConfigurationInfoProvider settingsProvider) {
        return new CoverageRunnerData();
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, final @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner", "doExecute"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner", "doExecute"));
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        KarmaRunProfileState runProfileState = (KarmaRunProfileState)ObjectUtils.tryCast((Object)state, KarmaRunProfileState.class);
        if (runProfileState == null) {
            return null;
        }
        KarmaServer server = runProfileState.getServerOrStart(env.getExecutor());
        if (server == null) {
            return null;
        }
        KarmaCoveragePeer coveragePeer = KarmaCoverageProgramRunner.getCoveragePeer(server);
        KarmaCoverageStartupStatus status = coveragePeer.getStartupStatus();
        if (status != null) {
            if (status.isSuccessful()) {
                return KarmaCoverageProgramRunner.executeAfterSuccessfulInitialization(runProfileState, env, server);
            }
            return KarmaCoverageProgramRunner.showWarningConsole(status, server, env);
        }
        coveragePeer.onCoverageInitialized(new KarmaCoverageInitializationCallback(){

            @Override
            public void onCoverageInitialized(@NotNull KarmaCoverageStartupStatus startupStatus) {
                if (startupStatus == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startupStatus", "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner$1", "onCoverageInitialized"));
                }
                RunnerAndConfigurationSettings configuration = env.getRunnerAndConfigurationSettings();
                if (configuration != null) {
                    ProgramRunnerUtil.executeConfiguration((ExecutionEnvironment)env, (boolean)true, (boolean)true);
                }
            }
        });
        return KarmaCoverageProgramRunner.showWarningConsole(null, server, env);
    }

    @NotNull
    private static KarmaCoveragePeer getCoveragePeer(@NotNull KarmaServer server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner", "getCoveragePeer"));
        }
        KarmaCoveragePeer coveragePeer = server.getCoveragePeer();
        if (coveragePeer == null) {
            throw new RuntimeException("Coverage peer should be initialized");
        }
        KarmaCoveragePeer karmaCoveragePeer = coveragePeer;
        if (karmaCoveragePeer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner", "getCoveragePeer"));
        }
        return karmaCoveragePeer;
    }

    private static RunContentDescriptor showWarningConsole(@Nullable KarmaCoverageStartupStatus status, @NotNull KarmaServer server, @NotNull ExecutionEnvironment env) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner", "showWarningConsole"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner", "showWarningConsole"));
        }
        if (status != null && status.isKarmaCoveragePackageNeededToBeInstalled()) {
            server.getRestarter().requestRestart();
        }
        KarmaCoverageConfigurationErrorConsole console = new KarmaCoverageConfigurationErrorConsole(env.getProject(), server, status);
        NopProcessHandler processHandler = new NopProcessHandler();
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter((ProcessHandler)processHandler){
            final /* synthetic */ ProcessHandler val$processHandler;
            {
                this.val$processHandler = processHandler;
            }

            public void startNotified(ProcessEvent event) {
                this.val$processHandler.destroyProcess();
            }
        });
        DefaultExecutionResult executionResult = new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)processHandler);
        RunContentBuilder contentBuilder = new RunContentBuilder((ExecutionResult)executionResult, env);
        return contentBuilder.showRunContent(env.getContentToReuse());
    }

    @NotNull
    private static RunContentDescriptor executeAfterSuccessfulInitialization(@NotNull KarmaRunProfileState state, @NotNull ExecutionEnvironment env, @NotNull KarmaServer server) throws ExecutionException {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner", "executeAfterSuccessfulInitialization"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner", "executeAfterSuccessfulInitialization"));
        }
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner", "executeAfterSuccessfulInitialization"));
        }
        if (server.areBrowsersReady()) {
            RunContentDescriptor runContentDescriptor = KarmaCoverageProgramRunner.doCoverage(state, env, server);
            if (runContentDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner", "executeAfterSuccessfulInitialization"));
            }
            return runContentDescriptor;
        }
        ExecutionResult executionResult = state.executeWithServer(env.getExecutor(), server);
        RunContentBuilder contentBuilder = new RunContentBuilder(executionResult, env);
        RunContentDescriptor descriptor = contentBuilder.showRunContent(env.getContentToReuse());
        server.onBrowsersReady(() -> ExecutionUtil.restartIfActive((RunContentDescriptor)descriptor));
        RunContentDescriptor runContentDescriptor = descriptor;
        if (runContentDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner", "executeAfterSuccessfulInitialization"));
        }
        return runContentDescriptor;
    }

    @NotNull
    private static RunContentDescriptor doCoverage(@NotNull KarmaRunProfileState state, final @NotNull ExecutionEnvironment env, final @NotNull KarmaServer server) throws ExecutionException {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner", "doCoverage"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner", "doCoverage"));
        }
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner", "doCoverage"));
        }
        final KarmaRunConfiguration runConfiguration = (KarmaRunConfiguration)env.getRunProfile();
        CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)runConfiguration);
        CoverageHelper.resetCoverageSuit((RunConfigurationBase)runConfiguration);
        final String coverageFilePath = coverageEnabledConfiguration.getCoverageFilePath();
        if (coverageFilePath != null) {
            KarmaCoveragePeer coveragePeer = KarmaCoverageProgramRunner.getCoveragePeer(server);
            coveragePeer.startCoverageSession(new KarmaCoverageSession(){

                @Override
                public void onCoverageSessionFinished(@NotNull File lcovFile) {
                    if (lcovFile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lcovFile", "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner$3", "onCoverageSessionFinished"));
                    }
                    UIUtil.invokeLaterIfNeeded(() -> {
                        if (lcovFile == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lcovFile", "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner$3", "lambda$onCoverageSessionFinished$0"));
                        }
                        if (env == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner$3", "lambda$onCoverageSessionFinished$0"));
                        }
                        if (server == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner$3", "lambda$onCoverageSessionFinished$0"));
                        }
                        try {
                            FileUtil.copy((File)lcovFile, (File)new File(coverageFilePath));
                        }
                        catch (IOException e) {
                            LOG.error("Can't copy files from " + lcovFile.getAbsolutePath() + " to " + coverageFilePath, (Throwable)e);
                            return;
                        }
                        RunnerSettings runnerSettings = env.getRunnerSettings();
                        if (runnerSettings != null) {
                            KarmaCoverageRunner coverageRunner = KarmaCoverageRunner.getInstance();
                            coverageRunner.setKarmaServer(server);
                            CoverageDataManager.getInstance((Project)env.getProject()).processGatheredCoverage((RunConfigurationBase)runConfiguration, runnerSettings);
                        }
                    });
                }
            });
        }
        ExecutionResult executionResult = state.executeWithServer(env.getExecutor(), server);
        RunContentBuilder contentBuilder = new RunContentBuilder(executionResult, env);
        RunContentDescriptor runContentDescriptor = contentBuilder.showRunContent(env.getContentToReuse());
        if (runContentDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner", "doCoverage"));
        }
        return runContentDescriptor;
    }
}

